package com.digiwin.athena.controller;

import com.digiwin.athena.dto.ResultDto;
import com.digiwin.athena.http.asset.PermissionConditionResDto;
import com.digiwin.athena.service.ResourceRoleService;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/permission")
@RequiredArgsConstructor
public class PermissionInfoController {

    private final ResourceRoleService resourceRoleService;

    @PostMapping("/getRowPermissionInfo")
    public ResultDto<PermissionConditionResDto> getRowPermissionInfo(){
        PermissionConditionResDto res = resourceRoleService.getRowPermissionInfo();
        return ResultDto.createSuccess(res);
    }
}
