package com.digiwin.athena.dao;

import com.digiwin.athena.auth.metadata.domain.AuthorityPolicy;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;

@Slf4j
@Repository
public class AuthorityPolicyMongoDao {

    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;


    public void insert(AuthorityPolicy authorityPolicy) {
        mongoSystemRepositoryDecorator.insert(authorityPolicy);
    }

    public List<AuthorityPolicy> selectByCodeAndResourceTypeAndAuthTypeAndResourceId(String userId, String resourceType, String authType, Collection<String> resourceIds) {
        Criteria queryCondition = Criteria.where("code").regex(userId)
                .and("resourceType").is(resourceType)
                .and("authType").is(authType)
                .and("resourceId").in(resourceIds);


        return mongoSystemRepositoryDecorator.find(new Query(queryCondition),AuthorityPolicy.class);
    }

    public void removeByCodeAndResourceId(String code, String resourceId) {
        Criteria criteria = Criteria.where("code").regex(code).and("resourceId").is(resourceId);
        mongoSystemRepositoryDecorator.remove(new Query(criteria), AuthorityPolicy.class);
    }
}
