/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.digiwin.athena.auth.metadata.domain.Authority;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import jakarta.annotation.Resource;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class AuthorityMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthorityMongoDao.class);
    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public List<Authority> selectByRoleAndSubjectCodeAndResourceId(String roleType, String userId, String resourceId) {
        Criteria c = Criteria.where((String)"accreditRole").regex(roleType).and("subjectCode").is((Object)userId).and("resourceId").is((Object)resourceId);
        return this.mongoSystemRepositoryDecorator.find(new Query((CriteriaDefinition)c), Authority.class);
    }

    public long countBySubjectCodeAndAccreditRoleAndResourceId(String subjectCode, String role, String resourceId) {
        Criteria criteria = Criteria.where((String)"subjectCode").is((Object)subjectCode).and("accreditRole").is((Object)role).and("resourceId").is((Object)resourceId);
        return this.mongoSystemRepositoryDecorator.count(new Query((CriteriaDefinition)criteria), Authority.class);
    }

    public void insert(Authority authority) {
        this.mongoSystemRepositoryDecorator.insert((Object)authority);
    }

    public List<Authority> selectBySubjectCodeAndResourceId(String subjectCode, List<String> resourceIds) {
        return this.mongoSystemRepositoryDecorator.find(new Query((CriteriaDefinition)Criteria.where((String)"subjectCode").is((Object)subjectCode).and("resourceId").in(resourceIds)), Authority.class);
    }

    public void removeByRoleAndSubjectCodeAndResourceId(String role, String userId, String resourceId) {
        Criteria criteria = Criteria.where((String)"accreditRole").is((Object)role).and("subjectCode").is((Object)userId).and("resourceId").is((Object)resourceId);
        this.mongoSystemRepositoryDecorator.remove(new Query((CriteriaDefinition)criteria), Authority.class);
    }
}

