package com.digiwin.athena.dao;

import com.digiwin.athena.auth.metadata.constants.AuthConstant;
import com.digiwin.athena.auth.metadata.domain.ResourceRole;
import com.digiwin.athena.auth.metadata.enums.AuthStatusEnum;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import com.digiwin.athena.utils.user.UserHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class ResourceRoleMongoDao {
    @Autowired
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;


    /**
     * 删除待审核的
     * @param userId
     * @param appCodes
     * @param tenantId
     */
    public void removeByToAuditCondition(String userId, List<String> appCodes, String tenantId) {
        Criteria toAuditCondition = Criteria.where("userId").is(userId)
                .and("status").is(AuthStatusEnum.TO_AUDIT.name());
        Criteria resourceIdCondition = new Criteria().orOperator(Criteria.where("resourceId").in(appCodes), Criteria.where("resourceId").is(tenantId));
        mongoSystemRepositoryDecorator.remove(new Query(new Criteria().andOperator(toAuditCondition, resourceIdCondition)), "resourceRole");
    }

    public void removeByUserIdAndResourceTypeAndResourceIdAndStatus(String userId, String roleType, String resourceId, String name) {
        Criteria criteria = Criteria.where("userId").is(userId).and("resourceType").is(roleType)
                .and("resourceId").is(resourceId).and("status").is(name);
        mongoSystemRepositoryDecorator.remove(new Query(criteria), "resourceRole");
    }

    public ResourceRole findOne(Criteria criteria) {
        return mongoSystemRepositoryDecorator.findOne(new Query(criteria), ResourceRole.class);
    }

    public void insert(ResourceRole resourceRole) {
        mongoSystemRepositoryDecorator.insert(resourceRole);
    }

    public void removeByResourceIdAndUserIdAndRole(String resourceId, String userId, String role) {
        Criteria criteria = Criteria.where("resourceId").is(resourceId).and("userId").is(userId).and("role").is(role);
        mongoSystemRepositoryDecorator.remove(new Query(criteria), ResourceRole.class);

    }

    public Long checkIsTenantSuper(String userId, String resourceId) {
        Criteria criteria = Criteria.where("userId").is(userId).and("role").is("tenant:super").and("resourceId").is(resourceId);
        Query query = new Query(criteria);
        return mongoSystemRepositoryDecorator.count(query, ResourceRole.class);

    }

    public List<ResourceRole> selectByUserIdAndRoleAndResourceTypeAndStatus(String userId, List<String> roles, String resourceType, String status) {
        Criteria criteria = Criteria.where("userId").is(userId)
                .and("role").in(roles).and("resourceType").is(resourceType)
                .and("status").is(status);
        return mongoSystemRepositoryDecorator.find(new Query(criteria), ResourceRole.class);
    }
}
