package com.digiwin.athena.service.impl;

import com.digiwin.athena.auth.metadata.constants.AuthConstant;
import com.digiwin.athena.auth.metadata.domain.ResourceRole;
import com.digiwin.athena.auth.metadata.enums.AuthStatusEnum;
import com.digiwin.athena.dao.ResourceRoleMongoDao;
import com.digiwin.athena.http.asset.PermissionConditionResDto;
import com.digiwin.athena.http.asset.PermissionResDto;
import com.digiwin.athena.service.ResourceRoleService;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@Slf4j
@RequiredArgsConstructor
public class ResourceRoleServiceImpl implements ResourceRoleService {

    private final ResourceRoleMongoDao resourceRoleMongoDao;
    @Override
    public PermissionResDto getRowPermissionInfo() {
        String name = UserHelper.getCurrentUser().getName();
        String tenantId = CurThreadInfoUtils.getCurTokenTenant().getTenantId();
        Long count = resourceRoleMongoDao.checkIsTenantSuper(name,tenantId );
        if (count>0){
            return new PermissionResDto();
        }

        List<ResourceRole> resourceRoles = resourceRoleMongoDao.selectByUserIdAndRoleAndResourceTypeAndStatus(name,
                List.of("application:mgr","application:actor"),
                AuthConstant.ResourceType.APPLICATION,
                AuthStatusEnum.PASSED.name());
        if (!resourceRoles.isEmpty()){
            Collection<String> appCodes = resourceRoles.stream().map(ResourceRole::getResourceId).collect(Collectors.toSet());
            PermissionConditionResDto res = new PermissionConditionResDto();
            res.setType(PermissionConditionResDto.GROUP_TYPE);
            res.setLogic(PermissionConditionResDto.AND_LOGIC);

            PermissionConditionResDto.Condition condition = new PermissionConditionResDto.Condition();
            condition.setType(PermissionConditionResDto.Condition.CONDITION_TYPE);
            condition.setField("application");
            condition.setOperator(PermissionConditionResDto.Condition.IN_OPERATOR);
            condition.setValue(appCodes);

            res.setChildren(List.of(condition));

            PermissionResDto permissionResDto = new PermissionResDto();
            permissionResDto.setRowPermission(res);
            return permissionResDto;
        }
        return null;
    }
}
