/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.impl;

import com.digiwin.athena.auth.metadata.domain.ResourceRole;
import com.digiwin.athena.auth.metadata.enums.AuthStatusEnum;
import com.digiwin.athena.dao.ResourceRoleMongoDao;
import com.digiwin.athena.http.asset.PermissionConditionResDto;
import com.digiwin.athena.http.asset.PermissionResDto;
import com.digiwin.athena.service.ResourceRoleService;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ResourceRoleServiceImpl
implements ResourceRoleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceRoleServiceImpl.class);
    private final ResourceRoleMongoDao resourceRoleMongoDao;

    @Override
    public PermissionResDto getRowPermissionInfo() {
        String tenantId;
        String name = UserHelper.getCurrentUser().getName();
        Long count = this.resourceRoleMongoDao.checkIsTenantSuper(name, tenantId = CurThreadInfoUtils.getCurTokenTenant().getTenantId());
        if (count > 0L) {
            return new PermissionResDto();
        }
        List<ResourceRole> resourceRoles = this.resourceRoleMongoDao.selectByUserIdAndRoleAndResourceTypeAndStatus(name, List.of("application:mgr", "application:actor"), "application", AuthStatusEnum.PASSED.name());
        if (!resourceRoles.isEmpty()) {
            Collection appCodes = resourceRoles.stream().map(ResourceRole::getResourceId).collect(Collectors.toSet());
            PermissionConditionResDto res = new PermissionConditionResDto();
            res.setType("group");
            res.setLogic("and");
            PermissionConditionResDto.Condition condition = new PermissionConditionResDto.Condition();
            condition.setType("condition");
            condition.setField("application");
            condition.setOperator("in");
            condition.setValue((Object)appCodes);
            res.setChildren(List.of(condition));
            PermissionResDto permissionResDto = new PermissionResDto();
            permissionResDto.setRowPermission(res);
            return permissionResDto;
        }
        return null;
    }

    @Generated
    public ResourceRoleServiceImpl(ResourceRoleMongoDao resourceRoleMongoDao) {
        this.resourceRoleMongoDao = resourceRoleMongoDao;
    }
}

