package com.digiwin.athena.dao;

import com.digiwin.athena.auth.metadata.domain.ResourceAuthorization;
import com.digiwin.athena.auth.metadata.enums.AuthStatusEnum;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class ResourceAuthorizationMongoDao {

    @Autowired
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    /**
     * 删除待审核的记录
     * @param userId
     * @param appCodes
     * @param tenantId
     */
    public void removeByToAuditCondition(String userId, List<String> appCodes, String tenantId) {
        Criteria toAuditCondition = Criteria.where("accreditObject").is(userId)
                .and("status").is(AuthStatusEnum.TO_AUDIT.name());
        Criteria resourceIdCondition = new Criteria().orOperator(Criteria.where("resourceId").in(appCodes), Criteria.where("resourceId").is(tenantId));

        mongoSystemRepositoryDecorator.remove(new Query(new Criteria().andOperator(toAuditCondition, resourceIdCondition)), ResourceAuthorization.class);
    }

    public void removeByAccreditObjectAndRoleAndResourceIdAndStatus(String accreditObject, String roleType, String resourceId, String name) {
        Criteria toAuditSameRoleCondition = Criteria.where("accreditObject").is(accreditObject).and("accreditRole").regex(roleType)
                .and("resourceId").is(resourceId).and("status").is(name);
        mongoSystemRepositoryDecorator.remove(new Query(toAuditSameRoleCondition), ResourceAuthorization.class);
    }

    public void insert(ResourceAuthorization resourceAuthorization) {
        mongoSystemRepositoryDecorator.insert(resourceAuthorization);
    }

    public void removeByRoleAndResourceIdAndAccreditObject(String accreditRole, String resourceId, String accreditObject) {
        Criteria criteria = Criteria.where("accreditRole").is(accreditRole).and("resourceId").is(resourceId).and("accreditObject").is(accreditObject);
        mongoSystemRepositoryDecorator.remove(new Query(criteria), ResourceAuthorization.class);

    }
}
