package com.digiwin.athena.dao;

import com.digiwin.athena.auth.metadata.domain.Authority;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import jakarta.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Slf4j
@Repository
public class AuthorityMongoDao {
    @Resource
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public List<Authority> selectByRoleAndSubjectCodeAndResourceId(String roleType, String userId, String resourceId) {
        Criteria c = Criteria.where("accreditRole").regex(roleType)
                .and("subjectCode").is(userId)
                .and("resourceId").is(resourceId);
        return mongoSystemRepositoryDecorator.find(new Query(c),Authority.class);
    }

    public long countBySubjectCodeAndAccreditRoleAndResourceId(String subjectCode, String role, String resourceId) {
        Criteria criteria = Criteria.where("subjectCode").is(subjectCode)
                .and("accreditRole").is(role)
                .and("resourceId").is(resourceId);
        return mongoSystemRepositoryDecorator.count(new Query(criteria), Authority.class);
    }

    public void insert(Authority authority) {
        mongoSystemRepositoryDecorator.insert(authority);
    }

    public List<Authority> selectBySubjectCodeAndResourceId(String subjectCode, List<String> resourceIds) {
        return mongoSystemRepositoryDecorator.find(new Query(Criteria.where("subjectCode").is(subjectCode).and("resourceId").in(resourceIds)), Authority.class);
    }

    public void removeByRoleAndSubjectCodeAndResourceId(String role, String userId, String resourceId) {
        Criteria criteria = Criteria.where("accreditRole").is(role).and("subjectCode").is(userId).and("resourceId").is(resourceId);
        mongoSystemRepositoryDecorator.remove(new Query(criteria), Authority.class);

    }
}
