/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.digiwin.athena.auth.metadata.domain.ResourceRole;
import com.digiwin.athena.auth.metadata.enums.AuthStatusEnum;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class ResourceRoleMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceRoleMongoDao.class);
    @Autowired
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public void removeByToAuditCondition(String userId, List<String> appCodes, String tenantId) {
        Criteria toAuditCondition = Criteria.where((String)"userId").is((Object)userId).and("status").is((Object)AuthStatusEnum.TO_AUDIT.name());
        Criteria resourceIdCondition = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"resourceId").in(appCodes), Criteria.where((String)"resourceId").is((Object)tenantId)});
        this.mongoSystemRepositoryDecorator.remove(new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{toAuditCondition, resourceIdCondition})), "resourceRole");
    }

    public void removeByUserIdAndResourceTypeAndResourceIdAndStatus(String userId, String roleType, String resourceId, String name) {
        Criteria criteria = Criteria.where((String)"userId").is((Object)userId).and("resourceType").is((Object)roleType).and("resourceId").is((Object)resourceId).and("status").is((Object)name);
        this.mongoSystemRepositoryDecorator.remove(new Query((CriteriaDefinition)criteria), "resourceRole");
    }

    public ResourceRole findOne(Criteria criteria) {
        return (ResourceRole)this.mongoSystemRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), ResourceRole.class);
    }

    public void insert(ResourceRole resourceRole) {
        this.mongoSystemRepositoryDecorator.insert((Object)resourceRole);
    }

    public void removeByResourceIdAndUserIdAndRole(String resourceId, String userId, String role) {
        Criteria criteria = Criteria.where((String)"resourceId").is((Object)resourceId).and("userId").is((Object)userId).and("role").is((Object)role);
        this.mongoSystemRepositoryDecorator.remove(new Query((CriteriaDefinition)criteria), ResourceRole.class);
    }
}

