/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ZipUtil;
import com.digiwin.athena.base.BusinessException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadUtils.class);
    public static final Map<String, String> FILE_TYPE_MAP = new HashMap<String, String>();

    public static void download(HttpServletResponse response, InputStream inputStream, String fileName) throws IOException {
        try {
            int bytesRead;
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            byte[] buffer = new byte[8096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                response.getOutputStream().write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            log.error(fileName + " \u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new BusinessException(fileName + " \u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25" + e.getMessage());
        }
        finally {
            inputStream.close();
            response.getOutputStream().close();
        }
    }

    public static void showPic(HttpServletResponse response, InputStream inputStream) throws IOException {
        try {
            int bytesRead;
            response.setContentType("image/jpeg");
            byte[] buffer = new byte[8096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                response.getOutputStream().write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            log.error("showPic" + e.getMessage(), (Throwable)e);
            throw new BusinessException("showPic" + e.getMessage());
        }
        finally {
            inputStream.close();
            response.getOutputStream().close();
        }
    }

    public static List<File> getZipFile(String compiledZipPath, InputStream inputStream) {
        FileUtil.writeFromStream((InputStream)inputStream, (String)(compiledZipPath + ".zip"));
        ZipUtil.unzip((String)(compiledZipPath + ".zip"), (String)compiledZipPath);
        NameFileFilter nameFileFilter = new NameFileFilter(".DS_Store");
        NotFileFilter notFileFilter = new NotFileFilter((IOFileFilter)nameFileFilter);
        List files = FileUtil.loopFiles((String)compiledZipPath, (FileFilter)notFileFilter);
        return files;
    }

    public static final String getFileTypeByStream(byte[] b) {
        String filetypeHex = String.valueOf(DownloadUtils.getFileHexString(b));
        for (Map.Entry<String, String> entry : FILE_TYPE_MAP.entrySet()) {
            String fileTypeHexValue = entry.getValue();
            if (!filetypeHex.toUpperCase().startsWith(fileTypeHexValue)) continue;
            return entry.getKey();
        }
        return null;
    }

    private static String getFileHexString(byte[] b) {
        StringBuilder stringBuilder = new StringBuilder();
        if (b == null || b.length == 0) {
            return null;
        }
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    static {
        FILE_TYPE_MAP.put("jpg", "FFD8FF");
        FILE_TYPE_MAP.put("png", "89504E47");
        FILE_TYPE_MAP.put("gif", "47494638");
        FILE_TYPE_MAP.put("tif", "49492A00");
        FILE_TYPE_MAP.put("bmp", "424D");
        FILE_TYPE_MAP.put("dwg", "41433130");
        FILE_TYPE_MAP.put("html", "68746D6C3E");
        FILE_TYPE_MAP.put("rtf", "7B5C727466");
        FILE_TYPE_MAP.put("xml", "3C3F786D6C");
        FILE_TYPE_MAP.put("zip", "504B0304");
        FILE_TYPE_MAP.put("rar", "52617221");
        FILE_TYPE_MAP.put("psd", "38425053");
        FILE_TYPE_MAP.put("eml", "44656C69766572792D646174653A");
        FILE_TYPE_MAP.put("dbx", "CFAD12FEC5FD746F");
        FILE_TYPE_MAP.put("pst", "2142444E");
        FILE_TYPE_MAP.put("xls", "D0CF11E0");
        FILE_TYPE_MAP.put("doc", "D0CF11E0");
        FILE_TYPE_MAP.put("mdb", "5374616E64617264204A");
        FILE_TYPE_MAP.put("wpd", "FF575043");
        FILE_TYPE_MAP.put("eps", "252150532D41646F6265");
        FILE_TYPE_MAP.put("ps", "252150532D41646F6265");
        FILE_TYPE_MAP.put("pdf", "255044462D312E");
        FILE_TYPE_MAP.put("qdf", "AC9EBD8F");
        FILE_TYPE_MAP.put("pwl", "E3828596");
        FILE_TYPE_MAP.put("wav", "57415645");
        FILE_TYPE_MAP.put("avi", "41564920");
        FILE_TYPE_MAP.put("ram", "2E7261FD");
        FILE_TYPE_MAP.put("rm", "2E524D46");
        FILE_TYPE_MAP.put("mpg", "000001BA");
        FILE_TYPE_MAP.put("mov", "6D6F6F76");
        FILE_TYPE_MAP.put("asf", "3026B2758E66CF11");
        FILE_TYPE_MAP.put("mid", "4D546864");
    }
}

