/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public class ExtendSimpleMongoRepository<T, ID extends Serializable>
extends SimpleMongoRepository<T, ID> {
    private final MongoOperations mongoOperations;
    private final MongoEntityInformation<T, ID> entityInformation;

    public ExtendSimpleMongoRepository(MongoEntityInformation<T, ID> metadata, MongoOperations mongoOperations) {
        super(metadata, mongoOperations);
        this.entityInformation = metadata;
        this.mongoOperations = mongoOperations;
    }

    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities not be null!");
        Streamable source = Streamable.of(entities);
        boolean allNew = source.stream().allMatch(it -> this.entityInformation.isNew(it));
        if (allNew) {
            List result = source.stream().collect(Collectors.toList());
            return new ArrayList(this.mongoOperations.insert(result, this.entityInformation.getCollectionName()));
        }
        return source.stream().map(arg_0 -> ((ExtendSimpleMongoRepository)this).save(arg_0)).collect(Collectors.toList());
    }

    public <S extends T> Page<S> findAll(Example<S> example, Query query2, Pageable pageable) {
        query2.addCriteria((CriteriaDefinition)new Criteria().alike(example)).with(pageable);
        List list = this.mongoOperations.find(query2, example.getProbeType(), this.entityInformation.getCollectionName());
        return PageableExecutionUtils.getPage((List)list, (Pageable)pageable, () -> this.mongoOperations.count(query2, example.getProbeType(), this.entityInformation.getCollectionName()));
    }

    public <S extends T> Page<T> findAll(Query query2, Pageable pageable) {
        query2.with(pageable);
        List list = this.mongoOperations.find(query2, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
        return PageableExecutionUtils.getPage((List)list, (Pageable)pageable, () -> this.mongoOperations.count(query2, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName()));
    }
}

