package com.digiwin.athena.constant;

import lombok.Getter;

@Getter
public enum DeleteAppProjectAndOpsInfoTemplate {

    NO_NEED_CLEAN(2001003, "租户（%s）的应用(%s)下没有需要删除的专案信息"),

    CLEAN_SUCCESS(2001004, "租户（%s）的应用(%s)下专案信息已经清理完成");

    private final int code;
    private final String msg;


    DeleteAppProjectAndOpsInfoTemplate(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    // 使用格式化替代占位符
    public String format(Object... args) {
        return String.format(this.msg, args);
    }


}
