package com.digiwin.athena.config;

import com.digiwin.athena.config.mongodb.MongodbConfig;
import com.digiwin.athena.mysql.domain.archive.CollectionPKPO;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import jakarta.annotation.PostConstruct;
import java.util.*;

@Data
@Component
public class BranchConfig {

    private MongodbConfig mongodbConfig;

    @Autowired
    public void setMongodbConfig(MongodbConfig mongodbConfig) {
        this.mongodbConfig = mongodbConfig;
    }

    public static String DEV_BRANCH_NAME_DATABASE;

    public static String MASTER_BRANCH_NAME_DATABASE;

    public static String TEST_BRANCH_NAME_DATABASE;

    public static String BAK_BRANCH_NAME_DATABASE;

    public static String SYS_BRANCH_NAME_DATABASE;

    public static final String RUNTIME_BRANCH_NAME="runtime";

    public static Map<String, String> BRANCH_DB_MAP = new HashMap<>();
    public static final Map<String, String> INDIVIDUAL_BRANCH_DB_MAP = new HashMap<>();

    public static final Map<String,String> BRANCH_NAME_MAP = new HashMap<>();

    private final String ssoTokenPrefix = "ADP_SSO_TOKEN_PREFIX_";

    private final String ssoCurrentBranch = "ADP_SSO_CURRENT_BRANCH_";

    private final String workDir = "/usr/local/athenadesigner";

    public static final String DEV_BRANCH_NAME="develop";

    public static final String TEST_BRANCH_NAME="test";

    public static final String MASTER_BRANCH_NAME="master";

    public static final String BAK_BRANCH_NAME="bak";

    public static final String TENANT_BRANCH_NAME="tenant";

    private List<CollectionPKPO> extraCollectionPKPOs;

    private List<CollectionPKPO> noAppCodeCollectionPKPOs;

    @PostConstruct
    public void init() {
        BRANCH_NAME_MAP.put(DEV_BRANCH_NAME,"开发分支");
        BRANCH_NAME_MAP.put(TEST_BRANCH_NAME,"测试分支");
        BRANCH_NAME_MAP.put(MASTER_BRANCH_NAME,"正式分支");
        BRANCH_NAME_MAP.put(BAK_BRANCH_NAME,"备份分支");

        String masterDBName = mongodbConfig.getMasterDatabase();

        SYS_BRANCH_NAME_DATABASE = mongodbConfig.getMasterDatabase();
        BAK_BRANCH_NAME_DATABASE = mongodbConfig.getBakDatabase();
        TEST_BRANCH_NAME_DATABASE = mongodbConfig.getTestDatabase();
        MASTER_BRANCH_NAME_DATABASE = mongodbConfig.getMasterDatabase();
        DEV_BRANCH_NAME_DATABASE = mongodbConfig.getDatabase();

        BRANCH_DB_MAP.put("test", mongodbConfig.getTestDatabase());
        BRANCH_DB_MAP.put("master",mongodbConfig.getMasterDatabase());
        BRANCH_DB_MAP.put("bak", mongodbConfig.getBakDatabase());

        INDIVIDUAL_BRANCH_DB_MAP.put("test", mongodbConfig.getIndividualTestDatabase());
        INDIVIDUAL_BRANCH_DB_MAP.put("master", mongodbConfig.getIndividualMasterDatabase());
        INDIVIDUAL_BRANCH_DB_MAP.put("bak", mongodbConfig.getIndividualBakDatabase());

        extraCollectionPKPOs = Arrays.asList(
                new CollectionPKPO(masterDBName,"applicationExample","application","com.digiwin.athena.mongodb.domain.application.ApplicationExample"),
                new CollectionPKPO(masterDBName,"applicationInstallRecord","application","com.digiwin.athena.mongodb.domain.application.ApplicationInstallRecord"),
                new CollectionPKPO(masterDBName,"compileVersion", "application","com.digiwin.athena.domain.compile.CompileVersion"),
                new CollectionPKPO(masterDBName,"favourite", "application","com.digiwin.athena.mongodb.domain.favourite.Favourite"),
                new CollectionPKPO(masterDBName,"projectDetail", "application","com.digiwin.athena.domain.pageview.design.projectdetail.ProjectDetail"),
                new CollectionPKPO(masterDBName,"taskDetail", "application","com.digiwin.athena.domain.pageview.design.taskdetail.TaskDetail"),
                new CollectionPKPO(masterDBName,"transferError", "application","com.digiwin.athena.mongodb.domain.transfer.TransferError"),
                new CollectionPKPO(masterDBName,"gptUploadLog", "appCode","com.digiwin.athena.mongodb.domain.ai.GPTUploadLog"),
                new CollectionPKPO(masterDBName,"gptSessionInfo", "appCode","com.digiwin.athena.mongodb.domain.ai.GPTSessionInfo")
        );
        noAppCodeCollectionPKPOs = Arrays.asList(
                new CollectionPKPO(masterDBName,"presetData","","com.digiwin.athena.mongodb.domain.other.PresetData"),
                new CollectionPKPO(masterDBName,"mechanismPartDoc","","com.digiwin.athena.mechanism.pre.MechanismPartDoc"),
                new CollectionPKPO(masterDBName,"applicationParamConfig","","com.digiwin.athena.mongodb.domain.application.ApplicationParamConfig"),
                new CollectionPKPO(masterDBName,"applicationParamRelation","","com.digiwin.athena.mongodb.domain.application.ApplicationParamRelation"),
                new CollectionPKPO(masterDBName,"dataMap","","com.digiwin.athena.mongodb.domain.data.DataMap"),
                new CollectionPKPO(masterDBName,"espAsyncData","","com.digiwin.athena.mongodb.domain.other.EspAsyncData"),
                new CollectionPKPO(masterDBName,"product","","com.digiwin.athena.mongodb.domain.task.Product")
        );
    }

    public static final Map<String, List<String>> BRANCH_CREATE_MAP = new HashMap<>();
    static {
        BRANCH_CREATE_MAP.put("develop", Arrays.asList("test", "bak"));
        BRANCH_CREATE_MAP.put("test", Arrays.asList("master", "bak"));
        BRANCH_CREATE_MAP.put("master", Arrays.asList("bak"));
    }

    /**
     * 作业迁移 作业相关数据域domain与数据库集合名词匹配map
     */
    public static final Map<String, String> MODEL_DB_MAP_4_PAGE_DESIGN = new HashMap<>();
    static {
        MODEL_DB_MAP_4_PAGE_DESIGN.put("pageDesign", "pageDesign");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("neo4jActivity", "neo4jActivity");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("applicationRelation", "applicationRelation");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("pageDesignModelDslRelation", "pageDesignModelDslRelation");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("rule", "rules");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("businessDirModel", "businessDir");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("activityConfig", "activityConfigs");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("adTag", "adTag");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("taskRelation", "taskRelation");
        MODEL_DB_MAP_4_PAGE_DESIGN.put("pageUIElement", "pageUIElement");
    }


    // athenadesginer库里现有的collection（93张）
    // [SvcParam, actionBindingTag, actionFieldRelation, actionMetadata, activity, activityConfigs, activityVisibleConfig, adTag, adTemplate, application, applicationExample, applicationInstallRecord, applicationParam, applicationParamConfig, applicationParamRelation, applicationRelation, backupData, buttonConfigData, codeMapsToCode, collect, compileDetail, compileLog, compileLogDetail, compileVersion, compiledData, componentStructuredList, dataDescription, dataEntryRelation, dataFeatureSet, dataGroup, dataMap, dataProcessor, dataState, datasource, demoTest, demoTestXuxx001, deployLog, dictionary, duty, entityDiff, entityRelationAnnotation, errorLog, espAsyncData, executor, extendConfig, extendField, favourite, flowGraph, globalConfig, gptKnowledgeMap, gptLog, gptSessionInfo, gptUploadLog, jsonDiff, knowledge, mechanism, mechanismAbilities, mechanismCapacity, mechanismDefinition, mechanismGroup, mechanismLogic, mechanismOutputTemplate, mechanismPartDoc, mechanismTask, mechanismTheory, microServiceDomain, modelFieldsConfig, monitorRule, neo4jActivity, openWindowDefinition, pageCard, pageDesign, pageView, paradigm, presetData, principle, principleDetail, product, project, projectDetail, publishVersion, rules, statementRelation, summary, switchLog, tag-definition, task, taskDetail, taskRelation, testClass, transferError, transformActionRule, variableDefinition]
    // 确认不需要进行同步的collection（22张）
    // buttonConfigData,codeMapsToCode,demoTest,demoTestXuxx001,testClass,switchLog,summary,publishVersion,pageCard,modelFieldsConfig,microServiceDomain,mechanismTheory,mechanismTask,mechanismAbilities,knowledge,jsonDiff,globalConfig,entityDiff,dataProcessor,compileLogDetail,datasource,executor
    // 在collection_pk表里已配置过的collection记录(48张)
    // [SvcParam, actionBindingTag, actionFieldRelation, actionMetadata, activity, activityConfigs, activityVisibleConfig, adTag, adTemplate, application, applicationParam, applicationRelation, collect, componentStructuredList, dataDescription, dataEntryRelation, dataFeatureSet, dataGroup, dataState, dictionary, duty, entityRelationAnnotation, extendConfig, extendField, favorite, flowGraph, mechanism, mechanismCapacity, mechanismDefinition, mechanismGroup, mechanismLogic, mechanismOutputTemplate, monitorRule, neo4jActivity, openWindowDefinition, pageDesign, pageView, paradigm, principle, principleDetail, project, rules, statementRelation, tag-definition, task, taskRelation, transformActionRule, variableDefinition]
    // 需要关注的日志collection（6张）
    // compileLog,deployLog,errorLog,compileDetail,gptKnowledgeMap,gptLog

    // 有application但没有在collection_pk表里进行配置的collection记录（11张）
    private List<String> extraCollectionNames = Arrays.asList(
            "applicationExample","applicationInstallRecord","backupData","compiledData","compileVersion", "favourite",
            "projectDetail","taskDetail","transferError","gptUploadLog", "gptSessionInfo"
    );

    // 没有application的collection（7张）
//    List<String> noApplicationCollectionNames = Arrays.asList(
//            "presetData","mechanismPartDoc","applicationParamConfig","applicationParamRelation","dataMap", "espAsyncData","product"
//    );

    //作业迁移的collection对应的domain 7张表
    private List<String> pageDesignMigrationCollectionNames = Arrays.asList(
            "pageDesign","neo4jActivity","applicationRelation","pageDesignModelDslRelation","businessDir", "rules","activityConfigs","adTag","taskRelation","pageUIElement"
    );
}
