package com.digiwin.athena.constant;

import java.util.Arrays;
import java.util.List;

/**
 * @program: components
 * @description: 描述
 * @author: Tuo
 * @create: 2020-05-19 15:45
 **/

public interface Constant {

    String Authorization = "Authorization";

    String IAM_TOKEN = "digi-middleware-auth-user";

    String TOKEN = "token";

    String APP_TOKEN = "digi-middleware-auth-app";

    String ValidateCode = "ValidateCode";

    String base64ImgPrefix = "data:image/png;base64,";

    String defaultTenantId = "SYSTEM";

    String DEVELOP_BRANCH = "develop";

    String DESIGN_PATH = "design";

    String COMPILED_PATH = "compiled";

    String DOUBLE_CODE_SEPARATOR = "__";

    String SINGLE_CODE_SEPARATOR = "_";

    String COMMON_CODE = "common";

    String COMMON_NAME = "公共应用";

    String DATASTANDARDS_CODE = "DATASTANDARDS";

    String DATASTANDARDS_NAME = "数据标准";

    String SYSTEM = "SYSTEM";

    String TEST_VERSION = "1.0";

    String PROD_VERSION = "2.0";

    String DATA_ENTRY = "DATA_ENTRY";

    String STATEMENT = "STATEMENT";

    String TASK = "TASK";

    String PROJECT_TASK = "PROJECT_TASK";

    /**
     * 通过开发创建/修改的pageView的designVersion需设置为v2
     */
    String PAGE_VIEW_DESIGN_VERSION = "v2";

    String ACTION_ENUMKEY = "___";

    String ROUTER_KEY = "routerKey";

    String COMMON_APP = "commonApp";

    String ESPACTION_BINDAPP_SPLIT = ";";

    String BRANCH_KEY = "branch";

    /**
     * api模型关联类型:api
      */
    String MODELDESGIN_RELATEDTYPE_API ="api";

    /**
     * api模型关联类型:model
     */
    String MODELDESGIN_RELATEDTYPE_MODEL ="model";


    /**
     * api模型关系类型:relate-引用关联
     */
    String MODELDESGIN_RELATIONSHIP_RELATE="relate";


    /**
     * api模型关系类型:child-主子表
     */
    String MODELDESGIN_RELATTIONSHIP_CHILD ="child";

    // 应用类型：敏捷数据
    Integer APP_TYPE_AGILE_DATA= 6;

    // 应用类型：娜娜助手
    Integer APP_TYPE_ATHENA_ASSISTANT = 7;

    String TEMPLATE_ID = "templateId";

    String SNAPSHOT_SUFFIX = "snapshot";

    String ADP_VERSION = "adpVersion";

    String ADP_STATUS = "adpStatus";

    String TENANT_PROCESS_ID = "tenantProcessId";

    String LEVEL = "level";

    String LOCALE = "locale";

    String INDIVIDUAL_CASE = "individualCase";

    String INDIVIDUAL_CASE_APP_CODE = "individualCaseAppCode";

    String CUSTOM_COMPONENT_TYPE = "system_standard_component_type";

    String SYSTEM_CONTAINER_COMPONENT_TYPE = "system_container_component_type";

    String SYSTEM_CONTAINER_COMPONENT_REMOVEKEYS = "system_container_component_removekeys";

    // dsl 容器组件
    List<String> SYSTEM_CONTAINER_COMPONENT_TYPE_LIST
            = Arrays.asList("ATHENA_TABLE","FORM_LIST","TABS","COLLAPSE","LAYOUT","FLEXIBLE_BOX","GRIDSTER","FLEX","BUTTON_GROUP");

    // 特殊结构需要跳过
  List<String> SYSTEM_CONTAINER_COMPONENT_REMOVEKEY_LIST = Arrays.asList( "actions", "action", "operations","dataSourceSet","dataSourceList","queryButtons","queryCurrencyApi","actionParams","formatConfig","disabledDate");


}
