package com.digiwin.athena.mongodb.repository;

import com.digiwin.athena.config.BranchConfig;
import com.digiwin.athena.config.mongodb.MongodbConfig;
import jakarta.annotation.PostConstruct;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Repository
public class MongoRuntimeRepositoryDecorator extends MongoUserRepositoryDecorator{

    @Autowired
    private MongodbConfig mongodbConfig;

    private final static Map<String,String> BRANCH_DB_NAME_MAP= new HashMap<>();

    @PostConstruct
    public void initMethod(){
        BRANCH_DB_NAME_MAP.put(BranchConfig.RUNTIME_BRANCH_NAME,mongodbConfig.getRuntimeDatabase());
    }
    @Override
    Map<String, String> getBranchDBNameMap() {
        return BRANCH_DB_NAME_MAP;
    }

    @Override
    String getBranchName() {
        return BranchConfig.RUNTIME_BRANCH_NAME;
    }
}
