package com.digiwin.athena.utils;

import java.util.function.Supplier;

public class SwitchAdpVersionUtils {

    public static <T> T switchAdpVersion(String adpVersion, Supplier<T> supplier){
        String originalAdpVersion = CurThreadInfoUtils.getAdpVersion();
        try {
            CurThreadInfoUtils.setAdpVersion(adpVersion);
            return supplier.get();
        } finally {
            CurThreadInfoUtils.setAdpVersion(originalAdpVersion);
        }
    }

    public static void switchAdpVersion(String adpVersion, Runnable runnable){
        String originalAdpVersion = CurThreadInfoUtils.getAdpVersion();
        try {
            CurThreadInfoUtils.setAdpVersion(adpVersion);
             runnable.run();
        } finally {
            CurThreadInfoUtils.setAdpVersion(originalAdpVersion);
        }
    }

    public static <T> T switchAdpStatus(String adpState, Supplier<T> supplier){
        String originalAdpState = CurThreadInfoUtils.getAdpStatus();
        try {
            CurThreadInfoUtils.setAdpStatus(adpState);
            return supplier.get();
        } finally {
            CurThreadInfoUtils.setAdpStatus(originalAdpState);
        }
    }

    public static void switchAdpStatus(String adpState, Runnable runnable){
        String originalAdpState = CurThreadInfoUtils.getAdpStatus();
        try {
            CurThreadInfoUtils.setAdpStatus(adpState);
            runnable.run();
        } finally {
            CurThreadInfoUtils.setAdpStatus(originalAdpState);
        }
    }

}
