package com.digiwin.athena.constant.modelDriven;

import lombok.Getter;

import java.util.*;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @CreateDate 2023/5/29 <br>
 */
public enum OperationEnum {

    /**
     * 业务层API定义-详情查询
     */
    GET("detail.get", "查询", "detail.get", "detail"),

    /**
     * 业务层API定义-列表查询
     */
    GETLIST("list.get", "列表查询", "get", "list"),

    /**
     * 业务层API定义-创建
     */
    CREATE("create", "创建", "create", "create"),

    /**
     * 业务层API定义-更新
     */
    UPDATE("update", "更新", "update", "update"),

    /**
     * 业务层API定义-删除
     */
    DELETE("delete", "删除", "delete", "delete"),

    /**
     * 业务层API定义-生效
     */
    VALID("valid", "生效", "valid", "valid"),

    /**
     * 业务层API定义-失效
     */
    INVALID("invalid", "失效", "invalid", "invalid"),

    /**
     * 数据层API定义-查询
     */
    DATA_GET("get", "查询", null, "get"),

    /**
     * 数据层API定义-创建
     */
    DATA_CREATE("create", "创建", null, "create"),

    /**
     * 数据层API定义-更新
     */
    DATA_UPDATE("update", "更新", null, "update"),

    /**
     * 数据层API定义-删除
     */
    DATA_DELETE("delete", "删除", null, "delete");

    @Getter
    private final String code;

    @Getter
    private final String name;

    // 主要用于list.get 转为get，但是原有生成的api元数据不变
    @Getter
    private final String newCode;

    @Getter
    private final String type;

    OperationEnum(String code, String name, String newCode, String type) {
        this.code = code;
        this.name = name;
        this.newCode = newCode;
        this.type = type;
    }

    public static OperationEnum getEnum(String code) {
        for (OperationEnum enums : OperationEnum.getOperations()) {
            if (enums.getCode().equals(code)) {
                return enums;
            }
        }
        return null;
    }

    public static List<OperationEnum> getOperationEnumList(Boolean isManageStatus) {
        List<OperationEnum> operationEnums = new ArrayList<>();
        operationEnums.add(OperationEnum.GETLIST);
        operationEnums.add(OperationEnum.GET);
        operationEnums.add(OperationEnum.CREATE);
        operationEnums.add(OperationEnum.UPDATE);
        operationEnums.add(OperationEnum.DELETE);
        if (isManageStatus) {
            operationEnums.add(OperationEnum.VALID);
            operationEnums.add(OperationEnum.INVALID);
        }
        return operationEnums;
    }

    public static boolean isContains(OperationEnum operation) {
        Set<OperationEnum> validOperations = new HashSet<>(Arrays.asList(
                OperationEnum.CREATE,
                OperationEnum.UPDATE,
                OperationEnum.VALID,
                OperationEnum.INVALID
        ));
        return validOperations.contains(operation);
    }

    public static boolean isContainValid(OperationEnum operation) {
        Set<OperationEnum> validOperations = new HashSet<>(Arrays.asList(
                OperationEnum.VALID,
                OperationEnum.INVALID
        ));
        return validOperations.contains(operation);
    }

    public static String getNewCode(String code) {
        for (OperationEnum enums : OperationEnum.getOperations()) {
            if (enums.getCode().equals(code)) {
                return enums.getNewCode();
            }
        }
        return null;
    }

    /**
     * 获取业务层API
     *
     * @return list
     */
    public static List<OperationEnum> getOperations() {
        List<OperationEnum> operationEnums = new ArrayList<>();
        operationEnums.add(OperationEnum.CREATE);
        operationEnums.add(OperationEnum.DELETE);
        operationEnums.add(OperationEnum.GET);
        operationEnums.add(OperationEnum.UPDATE);
        operationEnums.add(OperationEnum.VALID);
        operationEnums.add(OperationEnum.INVALID);
        operationEnums.add(OperationEnum.GETLIST);
        return operationEnums;
    }

    /**
     * 获取数据层API
     *
     * @return list
     */
    public static List<OperationEnum> getDataOperations() {
        List<OperationEnum> dataOperationEnums = new ArrayList<>();
        dataOperationEnums.add(OperationEnum.DATA_CREATE);
        dataOperationEnums.add(OperationEnum.DATA_DELETE);
        dataOperationEnums.add(OperationEnum.DATA_GET);
        dataOperationEnums.add(OperationEnum.DATA_UPDATE);
        return dataOperationEnums;
    }

}