package com.digiwin.athena.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * @author yueyyc
 * @version 1.0
 * @date 2022/12/7 14:09
 */
public class TbbDataTypeConstant {
    protected static final Map<String,String> LCDP_MAPPING_TBB = new HashMap<>();
    static {
        LCDP_MAPPING_TBB.put("datetime","date");
        LCDP_MAPPING_TBB.put("decimal","number");
        LCDP_MAPPING_TBB.put("json","string");
        LCDP_MAPPING_TBB.put("boolean","string");
    }
    public static String transDateType(String sourceType) {
        for (String key : LCDP_MAPPING_TBB.keySet()) {
            if (key.equals(sourceType)) {
                return LCDP_MAPPING_TBB.get(key);
            }
        }
        return sourceType;
    }
}
