package com.digiwin.athena.utils;

import org.springframework.context.i18n.LocaleContextHolder;

public class LocaleContextHolderUtils {

    public static final String DEFAULT_LOCALE = "en_US";

    public static String getLocale()
    {
        return LocaleContextHolder.getLocale().getLanguage() + "_" + LocaleContextHolder.getLocale().getCountry();
    }

    public static String getLocaleWithDefaultLocale()
    {
        if (null == LocaleContextHolder.getLocale()) {
            return DEFAULT_LOCALE;
        }

        return LocaleContextHolder.getLocale().getLanguage() + "_" + LocaleContextHolder.getLocale().getCountry();
    }


}