package com.digiwin.athena.utils.operation;

import com.digiwin.athena.utils.CurThreadInfoUtils;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.util.Date;

/**
 * @author yueyyc
 * @version 1.0
 * @date 2023/3/7 15:09
 */
@Data
@Slf4j
public class OperationRecordWrapper {
    private Integer id;
    private String application;
    private String branch;
    private String tableName;
    private String contentKey;
    private String content;
    private Object contentObj;
    private String actionType;
    private String operationUser;
    private String operationTenant;
    private Date operationTime;
    private String adpVersion;

    public OperationRecordWrapper(String application, String tableName, Object contentObj, String actionType) {
        this.application = application;
        this.tableName = tableName;
        this.contentObj = contentObj;
        this.actionType = actionType;
        this.adpVersion = CurThreadInfoUtils.getAdpVersion();
    }
}
