package com.digiwin.athena.base;

import java.util.List;
import java.util.Map;

public interface BaseDao<T> {

    int insert(T t);

    int insertBatch(List<T> t);

    int save(T t);

    int update(T t);

    int delete(Object id);

    int deleteBatch(List<Object> id);

    T select(Object id);

    List<T> queryByMap(Map<String, Object> query);

    Long queryCountByMap(Map<String, Object> query);
}
