package com.digiwin.athena.constant.modelDriven;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @CreateDate 2023/5/21 <br>
 */
public enum MysqlDataTypeEnum {
    CHAR("CHAR", 64, null),
    VARCHAR("VARCHAR", 64, null),
    BINARY("BINARY", null, null),
    VARBINARY("VARBINARY", null, null),
    JSON("JSON", null, null),
    BIT("BIT", null, null),
    NUMERIC("NUMERIC", null, null),
    TINYINT("TINYINT", 1, null),
    SMALLINT("SMALLINT", 20, null),
    INT("INT", 20, null),
    BIGINT("BIGINT", 20, null),
    FLOAT("FLOAT", 10, 2),
    DOUBLE("DOUBLE", 10, 2),
    DECIMAL("DECIMAL", 10, 2),
    DATE("DATE", null, null),
    TIME("TIME", null, null),
    TIMESTAMP("TIMESTAMP", null, null),
    DATETIME("DATETIME", null, null),
    FILE("FILE", null, null),
    MULTIPLE("MULTIPLE", null, null),
    //GPT误差规避
    BOOLEAN("BOOLEAN", 1, null);

    private String code;

    private Integer size;

    private Integer scale;

    MysqlDataTypeEnum(String code, Integer size, Integer scale) {
        this.code = code;
        this.size = size;
        this.scale = scale;
    }

    public String getCode() {
        return code;
    }

    public Integer getSize() {
        return size;
    }

    private void setSize(Integer size) {
        this.size = size;
    }

    public Integer getScale() {
        return scale;
    }

    private void setScale(Integer scale) {
        this.scale = scale;
    }

    public static String getCodeByName(String name) {
        for (MysqlDataTypeEnum enums : MysqlDataTypeEnum.values()) {
            if (enums.name().equals(name)) {
                return enums.getCode();
            }
        }
        return null;
    }

    public static MysqlDataTypeEnum getEnum(String code) {
        for (MysqlDataTypeEnum enums : MysqlDataTypeEnum.values()) {
            if (enums.getCode().equals(code)) {
                return enums;
            }
        }
        return VARCHAR;
    }

}