package com.digiwin.athena.base;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * 实际实现使用ognl
 **/
@Data
public class Context {

    //processVariables预留一些关键字类的key 如tenantId,userId,productId等等
    private Map<String, Object> processVariables = new HashMap<>();
    private Map<String, Object> localVariables = new HashMap<>();
    private Map<String, Object> transientVariables = new HashMap<>();

    public Map<String, Object> variables() {
        Map<String, Object> variables = new HashMap<>();
        if (null != processVariables) {
            variables.putAll(processVariables);
        }
        if (null != localVariables) {
            variables.putAll(localVariables);
        }
        if (null != transientVariables) {
            variables.putAll(transientVariables);
        }

        return variables;
    }

}
