package com.digiwin.athena.base;

/**
 * @author liyuetao
 * @title: DomainConstants
 * @projectName athena_designer
 * @description: to do
 * @date 2022/5/2617:11
 */
public enum DomainTypeEnum {
    //任务
    TASK("Activity", "ACTIVITY"),
    //基础资料
    BASE_DATA("DataEntry", "DATA_ENTRY"),
    //报表
    STATEMENT("Statement", "STATEMENT"),
    //报表函数录入
    EXCEL_FUNCTION("ExcelFunction", "EXCEL_FUNCTION");

    private String type;

    private String domain;

    DomainTypeEnum(String type, String domain) {
        this.type = type;
        this.domain = domain;
    }

    public String getType() {
        return type;
    }



    public String getDomain() {
        return domain;
    }
 

    public static String getDomainByType(String type) {
        for (DomainTypeEnum domainTypeEnum : DomainTypeEnum.values()) {
            if (domainTypeEnum.getType().equals(type)) {
                return domainTypeEnum.getDomain();
            }
        }
        return null;
    }

    public static String getTypeByDomain(String domain) {
        for (DomainTypeEnum domainTypeEnum : DomainTypeEnum.values()) {
            if (domainTypeEnum.getDomain().equals(domain)) {
                return domainTypeEnum.getType();
            }
        }
        return null;
    }
}
