package com.digiwin.athena.constant;

import java.util.ArrayList;
import java.util.List;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @CreateDate 2022/3/28 <br>
 */
public class ApplicationConstant {

    /**
     * Application document Json Data Path /middle/mongo/applicationCode/dbname/application/applicationCode.json
     * ApplicationRelation document Json Data Path /middle/mongo/applicationCode/dbname/applicationRelation/key.json
     * VariableDefinition document Json Data Path /middle/mongo/applicationCode/dbname/variableDefinition/key.json
     */
    public final static String MIDDLE_MONGO_DATA_PATH_FORMAT = "./src/main/resources/middle/mongo/%s/%s/%s/%s.json";


    public final static String APPLICATION = "application";
    public final static String APPLICATIONRELATION = "applicationRelation";
    public final static String VARIABLEDEFINITION = "variableDefinition";

    public final static Integer APP_TYPE_DTD = 1;
    public final static Integer APP_TYPE_COLLECT_DATA = 2;
    public final static Integer APP_TYPE_COLLECT_DATA_TTT = 3;

    public final static String SOURCE_TYPE_TBB = "DATA_ANALYSIS";//数据分析
    public final static String SOURCE_TYPE_MODEL_DESIGN = "MODEL_DESIGN";//模型设计
    public final static String SOURCE_TYPE_BUSINESS_FLOW = "BUSINESS_FLOW";//业务流
    public final static String SOURCE_TYPE_GROUP = "GROUP";//分组
    public final static String SOURCE_TYPE_MODEL_DRIVEN = "MODEL_DRIVEN";//模型驱动作业

    // 应用子类型：综合类
    public static final Integer APP_SUB_TYPE_COMPOSITE = 4;

    // 应用子类型：事务类
    public static final Integer APP_SUB_TYPE_BUSINESS = 3;

    // 应用子类型：知识类
    public static final Integer APP_SUB_TYPE_KNOWLEDGE = 2;

    // 应用子类型：数据类
    public static final Integer APP_SUB_TYPE_DATA = 1;

    public final static List<String> PRESET_ACTION = new ArrayList<>();//预置action
    static {
        PRESET_ACTION.add("eoc_FindAllUser_dept");
        PRESET_ACTION.add("eoc_get_depts");
    }
}