package com.digiwin.athena.constant;

import java.util.ArrayList;
import java.util.List;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @CreateDate 2022/5/10 <br>
 */
public enum DataBaseFieldTypeEnum {
    // 数值类型
    CHAR("CHAR",255,160),
    // 字符串类型
    VARCHAR("VARCHAR",21845,160),
    // 对象类型
    BINARY("BINARY",255,0),
    // 布尔类型
    VARBINARY("VARBINARY",65535,0),
    TINYINT("TINYINT",255,80),
    SMALLINT("SMALLINT",255,80),
    INT("INT",255,80),
    BIGINT("BIGINT",255,80),
    FLOAT("FLOAT",255,160),
    DOUBLE("DOUBLE",255,160),
    DECIMAL("DECIMAL",65,160),
    BIT("BIT",1,80),
    DATE("DATE",0,160),
    DATETIME("DATETIME",6,200),
    TIME("TIME",6,150),
    NUMERIC("NUNERIC",0,0),
    JSON("JSON",0,160),
    FILE("FILE",0,160),
    MULTIPLE("MULTIPLE",0,160),
    TIMESTAMP("TIMESTAMP",6,200),
    TEXT("TEXT",0,160),
    TINYTEXT("TINYTEXT",0,160),
    MEDIUMTEXT("MEDIUMTEXT",0,160),
    LONGTEXT("LONGTEXT",0,160),
    BOOLEAN("BOOL",0,80);

    private Integer value;

    private String name;

    private Integer width;

    DataBaseFieldTypeEnum(String name,int value,int width) {
        this.width = width;
        this.name = name;
        this.value = value;
    }
    public static List<String> getPrecisionType(){
        List<String> list = new ArrayList<>();
        list.add(FLOAT.name);
        list.add(DOUBLE.name);
        list.add(DECIMAL.name);
        return list;
    }

    public static Integer getValue(String name){
        for(DataBaseFieldTypeEnum  dataBaseFieldTypeEnum  :  DataBaseFieldTypeEnum.values()){
            if(dataBaseFieldTypeEnum.name().equalsIgnoreCase(name)){
                return dataBaseFieldTypeEnum.value;
            }
        }
        return -1;
    }

    public static Integer getWidth(String name){
        for(DataBaseFieldTypeEnum  dataBaseFieldTypeEnum  :  DataBaseFieldTypeEnum.values()){
            if(dataBaseFieldTypeEnum.name().equalsIgnoreCase(name)){
                return dataBaseFieldTypeEnum.width;
            }
        }
        return -1;
    }
}