package com.digiwin.athena.constant.enumconstant;

import lombok.Getter;

/**
 * 模组对应的映射信息 Dap Athena
 */
public enum AppTypeEnum {

    TYPE_DTD(1, "数据驱动1.0", "TYPE_DTD", "Athena"),

    TYPE_COLLECT_DATA(2, "数据收集型应用", "TYPE_COLLECT_DATA", "Athena"),

    TYPE_COLLECT_DATA_V2(3, "数据收集型v2应用", "TYPE_COLLECT_DATA_V2", "Athena"),

    TYPE_FREECONTROL(4, "随心控", "TYPE_FREECONTROL", "Athena"),

    TYPE_TTT(5, "数据驱动2.0", "TYPE_TTT", "Athena"),

    TYPE_AGILEDATA(6, "敏捷数据", "TYPE_AGILEDATA", "Athena"),

    TYPE_NANA(7, "娜娜助手", "TYPE_NANA", "Athena"),

    TYPE_AI_MODEL(8, "大AI创建模型", "TYPE_AI_MODEL", "Athena"),

    TYPE_HIGH(9, "高代码应用", "TYPE_HIGH", "Dap"),

    TYPE_DATA_VIEW(10, "数据可视化应用", "TYPE_DATA_VIEW", "Athena"),

    TYPE_BDD(11, "业务领域中心", "TYPE_BDD", "Athena");

    @Getter
    private final Integer appType;

    @Getter
    private final String appName;

    @Getter
    private final String appCode;

    @Getter
    private final String serviceType;


    AppTypeEnum(Integer appType, String appName, String appCode, String serviceType) {
        this.appType = appType;
        this.appName = appName;
        this.appCode = appCode;
        this.serviceType = serviceType;
    }

    public static Boolean containsType(String appCode) {
        for (AppTypeEnum enums : AppTypeEnum.values()) {
            if (enums.getAppCode().equals(appCode)) {
                return true;
            }
        }
        return false;
    }

    public static String getCodeByType(Integer appType) {
        if (null == appType) {
            return null;
        }
        for (AppTypeEnum enums : AppTypeEnum.values()) {
            if (enums.getAppType().equals(appType)) {
                return enums.getAppCode();
            }
        }
        return null;
    }

}
