package com.digiwin.athena.constant.mechanism;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author PC
 * @version 1.0.0
 * @Date 2023/6/5 17:12
 */
public interface Constants {

    ExecutorService APP_EXECUTE_POOL = Executors.newCachedThreadPool();

    static final String defaultTenantId = "athenaPaasW";
    String RELATED_APP_EXPIRED = "RELATED_APP_EXPIRED";
    String USER_INTEGRITY_CHECK_SWITCH = "userIntegrityCheck";
    String PARADIGM_INIT_SWITCH = "paradigmInitSwitch";


    interface TaskType {
        String BUSINESS = "BUSINESS";
        String FEEDBACK = "FEEDBACK";
        String REPORT = "REPORT";
        String MECHANISM = "MECHANISM";
    }

    interface TaskLevel {
        String tenant = "tenant";
    }

    interface TaskLevelType {
        String modify = "modify";
        String add = "add";
    }

    interface DataEntrySourceType {
        int PROJECT = 1;

        int TASK = 2;
    }

    interface AppNoticeType{
        String CLEAN = "clean";
        String RENEW = "renew";
        String EXPIRE = "expire";
        int RETAIN_DAYS = 180;  //按许彦的要求把资料保留期从60天改为180天
    }

    interface MechanismDesignState{
        int DELETE = -1;
        int UNPUBLISHED = 0;
        int PUBLISHED = 1;

    }
}
