package com.digiwin.athena.constant.modelDriven;

/**
 * @Auther: wujiang
 * @Date: 2024/5/22 15:36
 * @Description:
 */

public enum ApiTypeEnum {

    DETAIL("detail","明细"),
    LIST("list","列表"),
    CREATE("create","创建"),
    UPDATE("update","更新"),
    DELETE("delete","删除"),
    VALID("valid", "生效"),
    INVALID("invalid","失效");

    private String code;
    private String name;

    ApiTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static ApiTypeEnum getEnum(String code){
        for(ApiTypeEnum enums: ApiTypeEnum.values()){
            if(enums.getCode().equals(code)){
                return enums;
            }
        }
        return null;
    }
}
