package com.digiwin.athena.utils;

import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import java.util.Collection;
import java.util.List;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @CreateDate 2022/7/12 <br>
 */
public class QueryUtils {

    public static Query findByCode(String code) {
        Query query = new Query(Criteria.where("code").is(code));
        return query;
    }

    public static Query findById(String id) {
        Query query = new Query(Criteria.where("_id").is(id));
        return query;
    }

    public static Query findByAppCode(String appCode) {
        Query query = new Query(Criteria.where("appCode").is(appCode));
        return query;
    }

    public static Query findByAppType(Integer appType) {
        Query query = new Query(Criteria.where("appType").is(appType));
        return query;
    }

    public static Query findBySkillCode(String skillCode) {
        Query query = new Query(Criteria.where("skillCode").is(skillCode));
        return query;
    }

    public static Query findByProjectCode(String projectCode) {
        Query query = new Query(Criteria.where("projectCode").is(projectCode));
        return query;
    }

    public static Query findByAssistantCodeAndType(String assistantCode,String type) {
        Query query = new Query(Criteria.where("assistantCode").is(assistantCode).and("type").is(type));
        return query;
    }

    public static Query findByApplicationCode(String appCode) {
        Query query = new Query(Criteria.where("applicationCode").is(appCode));
        return query;
    }

    public static Query findByAppCodeAndCode(String appCode, String code) {
        Query query = new Query(Criteria.where("appCode").is(appCode).and("code").is(code));
        return query;
    }

    public static Query findByAppCodeAndCodeAndType(String appCode, String code, String type) {
        Query query = new Query(Criteria.where("appCode").is(appCode).and("code").is(code).and("type").is(type));
        return query;
    }

    public static Query findByAppCodeAndType(String appCode, String type) {
        Query query = new Query(Criteria.where("application").is(appCode).and("type").is(type)/*.and("executeType").is(executeType)*/);
        return query;
    }

    public static Query findByAppCodeAndParamCode(String appCode, String code) {
        Query query = new Query(Criteria.where("appCode").is(appCode).and("paramCode").is(code));
        return query;
    }

    public static Query findByCodeAndTenantId(String code, String tenantId) {
        Query query = new Query(Criteria.where("code").is(code).and("tenantId").is(tenantId));
        return query;
    }

    public static Query findByApplication(String application) {
        Query query = new Query(Criteria.where("application").is(application));
        return query;
    }

    public static Query findByKey(String key) {
        Query query = new Query(Criteria.where("key").is(key));
        return query;
    }

    public static Query findByKeys(List<String> keys) {
        Query query = new Query(Criteria.where("key").in(keys));
        return query;
    }

    public static Query findByApplicationAndCode(String application, String code) {
        Query query = new Query(Criteria.where("application").is(application).and("code").is(code));
        return query;
    }

    public static Query findByApplicationAndId(String application, String id) {
        Query query = new Query(Criteria.where("application").is(application).and("id").is(id));
        return query;
    }

    public static Query findByApplicationCodeAndId(String application, String id) {
        Query query = new Query(Criteria.where("applicationCode").is(application).and("id").is(id));
        return query;
    }

    public static Query findByApplicationCodeAndId(String application, Long id) {
        Query query = new Query(Criteria.where("applicationCode").is(application).and("id").is(id));
        return query;
    }

    public static Query findByApplicationAndExecuteType(String application, String executeType) {
        Query query = new Query(Criteria.where("application").is(application).and("executeType").is(executeType));
        return query;
    }

    public static Query findByApplicationAndDomain(String application, String domain) {
        Query query = new Query(Criteria.where("application").is(application).and("domain").is(domain));
        return query;
    }

    public static Query findByApplicationAndDomainAndCode(String application, String domain, String code) {
        Criteria criteria = Criteria.where("application").is(application).and("domain").is(domain).and("taskCode").is(code);
        Criteria criteria2 = Criteria.where("application").is(application).and("domain").is(domain).and("domainId").is(code);
        Query query = new Query(new Criteria().orOperator(criteria, criteria2));
        return query;
    }

    public static Query findByGroupCode(String groupCode) {
        Query query = new Query(Criteria.where("groupCode").is(groupCode));
        return query;
    }

    public static Query findByApplicationAndGroupCode(String application, String groupCode) {
        Query query = new Query(Criteria.where("application").is(application).and("groupCode").is(groupCode));
        return query;
    }

    public static Query findByApplicationAndSkillCode(String application, String groupCode) {
        Query query = new Query(Criteria.where("application").is(application).and("skillCode").is(groupCode));
        return query;
    }

    public static Query findByApplicationAndGroupCodeAndDataCode(String application, String groupCode, String dataCode) {
        Query query = new Query(Criteria.where("application").is(application).and("groupCode").is(groupCode).and("dataCode").is(dataCode));
        return query;
    }

    public static Query findByApplicationAndSkillCodeAndDataCode(String application, String skillCode, String dataCode) {
        Query query = new Query(Criteria.where("application").is(application).and("skillCode").is(skillCode).and("dataCode").is(dataCode));
        return query;
    }

    public static Query findByApplicationAndPattern(String application, String pattern) {
        Query query = new Query(Criteria.where("application").is(application).and("pattern").is(pattern));
        return query;
    }

    public static Query findByActionId(String actionId) {
        Query query = new Query(Criteria.where("actionId").is(actionId));
        return query;
    }

    public static Query findByApplicationAndActionId(String application, String actionId) {
        Query query = new Query(Criteria.where("application").is(application).and("actionId").is(actionId));
        return query;
    }

    public static Query findByTaskCode(String taskCode) {
        Query query = new Query(Criteria.where("taskCode").is(taskCode));
        return query;
    }

    public static Query findByTaskCodeAndDomain(String taskCode, String domain) {
        Query query = new Query(Criteria.where("taskCode").is(taskCode).and("domain").is(domain));
        return query;
    }

    public static Query findByDomainIdAndDomainAndApplication(String domainId, String domain, String application) {
        Query query = new Query(Criteria.where("domainId").is(domainId).and("domain").is(domain).and("application").is(application));
        return query;
    }

    public static Query findByCompiledDocmentPathAndApplicationAndSceneCode(String compiledDocmentPath, String application, String sceneCode) {
        Query query = new Query(Criteria.where("compiledDocmentPath").is(compiledDocmentPath).and("application").is(application).and("sceneCode").is(sceneCode));
        return query;
    }

    public static Query findByConfigCode(String configCode) {
        Query query = new Query(Criteria.where("configCode").is(configCode));
        return query;
    }

    public static Query findByConfigCodeAndAbandon(String configCode) {
        Query query = new Query(Criteria.where("configCode").is(configCode).and("abandon").ne(1));
        return query;
    }

    public static Query findByPrimaryKeyAndSecondKeyAndSceneCode(String primaryKey, String secondKey, String sceneCode) {
        Query query = new Query(Criteria.where("primaryKey").is(primaryKey).and("secondKey").is(secondKey).and("sceneCode").is(sceneCode));
        return query;
    }

    public static Query findByPrimaryKeyAndSecondKeyAndSceneCodeAndAbandon(String primaryKey, String secondKey, String sceneCode) {
        Query query = new Query(Criteria.where("primaryKey").is(primaryKey).and("secondKey").is(secondKey).and("sceneCode").is(sceneCode).and("abandon").ne(1));
        return query;
    }

    public static Query findByPrimaryKeyAndSecondKeyAndSceneCodeAndApplicationAndAbandon(String primaryKey, String secondKey, String sceneCode, String application) {
        Query query = new Query(Criteria.where("primaryKey").is(primaryKey).and("secondKey").is(secondKey).and("sceneCode").is(sceneCode).and("application").is(application).and("abandon").ne(1));
        return query;
    }

    public static Query findByPrimaryKeyAndSceneCode(String primaryKey, String sceneCode) {
        Query query = new Query(Criteria.where("primaryKey").is(primaryKey).and("sceneCode").is(sceneCode));
        return query;
    }

    public static Query findBySceneCode(String sceneCode) {
        Query query = new Query(Criteria.where("sceneCode").is(sceneCode));
        return query;
    }

    public static Query findByApplicationAndStartActionIdAndEndActionId(String application, String startActionId, String endActionId) {
        Query query = new Query(Criteria.where("application").is(application).and("startActionId").is(startActionId).and("endActionId").is(endActionId));
        return query;
    }

    public static Query findByApplicationAndDataCodeAndName(String application, String dataCode, String name) {
        Query query = new Query(Criteria.where("application").is(application).and("name").is(name).and("dataCode").is(dataCode));
        return query;
    }

    public static Query findInCode(Collection<String> codes) {
        Query query = new Query(Criteria.where("code").in(codes));
        return query;
    }

    public static Query findInApplication(Collection<String> codes) {
        Query query = new Query(Criteria.where("application").in(codes));
        return query;
    }

    public static Query findByDomainId(String domainId) {
        Query query = new Query(Criteria.where("domainId").is(domainId));
        return query;
    }

    public static Query findByDomainAndDomainId(String domain, String domainId) {
        Query query = new Query(Criteria.where("domain").is(domain).and("domainId").is(domainId));
        return query;
    }

    public static Query findByDataCode(String dataCode) {
        Query query = new Query(Criteria.where("dataCode").is(dataCode));
        return query;
    }

    public static Query findByNameSpace(String nameSpace) {
        Query query = new Query(Criteria.where("nameSpace").is(nameSpace));
        return query;
    }

    public static Query findByNameSpaceAndCode(String nameSpace, String code) {
        Query query = new Query(Criteria.where("nameSpace").is(nameSpace).and("code").is(code));
        return query;
    }

    public static Query findByApplicationAndSourceType(String application, String sourceType) {
        Query query = new Query(Criteria.where("application").is(application).and("sourceType").is(sourceType));
        return query;
    }

    public static Query findByApplicationAndSourceTypeAndAbandon(String application) {
        Query query = new Query(Criteria.where("application").is(application).and("abandon").ne(1));
        return query;
    }

    public static Query findByKeyAndCode(String key, String code) {
        Query query = new Query(Criteria.where("key").is(key).and("code").is(code));
        return query;
    }

    public static Query findByCommonApp() {
        Query query = new Query(Criteria.where("commonApp").is(true));
        return query;
    }

    public static Query findByAbilityTypeAndAbilityCode(List<String> abilityType, String abilityCode) {
        Query query = new Query(
                Criteria.where("itemSteps.abilityType").in(abilityType))
                .addCriteria(Criteria.where("itemSteps.abilityCode").is(abilityCode));
        return query;
    }

    public static Query findByProjectCodeAndModelCode(String projectCode, String modelCode) {
        Query query = new Query(Criteria.where("projectCode").is(projectCode).and("modelCode").is(modelCode));
        return query;
    }

    public static Query findByProjectCodeAndModelCodeAndTrainVersion(String projectCode, String modelCode, String trainVersion) {
        Query query = new Query(Criteria.where("projectCode").is(projectCode).and("modelCode").is(modelCode).and("trainVersion").is(trainVersion));
        return query;
    }

    public static Query findByProjectCodeAndModelCodeAndBaseVersion(String projectCode, String modelCode, String baseVersion) {
        Query query = new Query(Criteria.where("projectCode").is(projectCode).and("modelCode").is(modelCode).and("baseVersion").is(baseVersion));
        return query;
    }

    public static Query findByModelCode(String modelCode) {
        Query query = new Query(Criteria.where("modelCode").is(modelCode));
        return query;
    }

    public static Query findByModelCodeAndIntent(String modelCode, String intent) {
        Query query = new Query(Criteria.where("modelCode").is(modelCode).and("intent").is(intent));
        return query;
    }

    public static Query findByCorpusCodesAndCorpusType(List<String> codes,Integer corpusType) {
        Query query = new Query(Criteria.where("corpusCode").in(codes).and("corpusType").is(corpusType));
        return query;
    }

    public static Query findByModelCodeAndStatus(String modelCode, String status) {
        Query query = new Query(Criteria.where("modelCode").is(modelCode).and("status").is(status));
        return query;
    }

    public static Query findByProjectCodeAndModelCodeAndCorpusType(String projectCode, String modelCode, Integer corpusType) {
        Query query = new Query(Criteria.where("projectCode").is(projectCode).and("modelCode").is(modelCode).and("corpusType").is(corpusType));
        return query;
    }

    public static Query findByIntentAndUtterances(String intent,String utterances){
        Query query = new Query(Criteria.where("intent").is(intent).and("utterances").is(utterances));
        return query;
    }

    public static Query findByCorpusCode(String corpusCode){
        Query query = new Query(Criteria.where("corpusCode").is(corpusCode));
        return query;
    }

    public static Query findByStatus(List<String> status) {
        Query query = new Query(Criteria.where("status").in(status));
        return query;
    }

    public static Query findByProjectCodeAndAssistantCode(String projectCode, String assistantCode) {
        Query query = new Query(Criteria.where("projectCode").is(projectCode).and("assistantCode").is(assistantCode));
        return query;
    }

    public static Query findByIntentAndUtterancesAndCorpusCode(String intent, String utterances, String corpusCode) {
        Query query = new Query(Criteria.where("intent").is(intent).and("utterances").is(utterances).and("corpusCode").ne(corpusCode));
        return query;
    }

    public static Query findBySynonymCode(String synonymCode) {
        Query query = new Query(Criteria.where("synonymCode").is(synonymCode));
        return query;
    }

    public static Query findBySynonymCodes(List<String> codes) {
        Query query = new Query(Criteria.where("synonymCode").in(codes));
        return query;
    }

    public static Query findByAppCodeAndTypeAndProperNoun(String appCode, String synonymType, String properNoun) {
        Query query = new Query(Criteria.where("application").is(appCode).and("synonymType").is(synonymType).and("properNoun").is(properNoun));
        return query;
    }

    public static Query findAllSynonymByAssistantCode(String application, String synonymType) {
        Query query = new Query(Criteria.where("application").is(application).and("synonymType").is(synonymType));
        return query;
    }

    public static Query findMaxSort(String code) {
        Query query = new Query();
        query.addCriteria(Criteria.where("application").is(code));
        query.addCriteria(Criteria.where("sort").exists(true));
        query.with(Sort.by(Sort.Order.desc("sort")));
        query.limit(1);
        return query;
    }
    public static Query findByModelIdAndServiceCode(String modelId,String serviceCode) {
        Query query = new Query(Criteria.where("modelId").is(modelId).and("serviceCode").is(serviceCode));
        return query;
    }

    public static Query findByModelIdAndProductCode(String modelId,String productCode) {
        Query query = new Query(Criteria.where("modelId").is(modelId).and("productCode").is(productCode));
        return query;
    }

    public static Query findBySimpleModelCodeAndServiceCode(String simpleModelCode,String serviceCode) {
        Query query = new Query(Criteria.where("simpleModelCode").is(simpleModelCode).and("serviceCode").is(serviceCode));
        return query;
    }

    public static Query findByProcessId(String code) {
        return new Query(Criteria.where("processId").is(code));
    }

}