/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JSUtil.class);

    public static <T> T evalResponse(String jsStr, String param, Class<T> returnType) {
        try (Context context = Context.newBuilder((String[])new String[]{"js"}).build();){
            Value bindings = context.getBindings("js");
            bindings.putMember("responseJSON", (Object)param);
            bindings.putMember("log", (Object)log);
            String js = "(function() {const response = JSON.parse(responseJSON);" + jsStr + "})();";
            Value result = context.eval("js", (CharSequence)js);
            T t = JSUtil.convert(result, returnType);
            return t;
        }
    }

    public static <T> T evalRequest(String jsStr, String param, Class<T> returnType) {
        try (Context context = Context.newBuilder((String[])new String[]{"js"}).build();){
            Value bindings = context.getBindings("js");
            bindings.putMember("requestJSON", (Object)param);
            bindings.putMember("log", (Object)log);
            String js = "(function() {const request = JSON.parse(requestJSON);" + jsStr + "})();";
            Value result = context.eval("js", (CharSequence)js);
            T t = JSUtil.convert(result, returnType);
            return t;
        }
    }

    private static <T> T convert(Value result, Class<T> returnType) {
        ObjectMapper mapper = new ObjectMapper();
        if (result.isNull()) {
            return null;
        }
        if (result.isString()) {
            String str = result.asString();
            if (returnType == String.class) {
                return returnType.cast(str);
            }
            try {
                return (T)mapper.readValue(str, returnType);
            }
            catch (Exception exception) {
                log.error("JS \u8fd4\u56de\u5b57\u7b26\u4e32\uff0c\u4f46\u65e0\u6cd5\u8f6c\u6362\u6210\u76ee\u6807\u7c7b\u578b", (Throwable)exception);
                throw new RuntimeException("JS \u8fd4\u56de\u5b57\u7b26\u4e32\uff0c\u4f46\u65e0\u6cd5\u8f6c\u6362\u6210\u76ee\u6807\u7c7b\u578b\uff1a" + returnType.getName());
            }
        }
        if (result.fitsInInt() && returnType == Integer.class) {
            return returnType.cast(result.asInt());
        }
        if (result.fitsInLong() && returnType == Long.class) {
            return returnType.cast(result.asLong());
        }
        if (result.fitsInDouble() && (returnType == Double.class || returnType == Double.TYPE)) {
            return returnType.cast(result.asDouble());
        }
        if (result.isBoolean() && (returnType == Boolean.class || returnType == Boolean.TYPE)) {
            return returnType.cast(result.asBoolean());
        }
        if (result.hasArrayElements() && returnType == List.class) {
            return (T)result.as(returnType);
        }
        if (result.hasMembers()) {
            Map map = (Map)result.as(Map.class);
            return (T)mapper.convertValue((Object)map, returnType);
        }
        return (T)result.as(returnType);
    }
}

