package com.digiwin.athena.constant.modelDriven;

/**
 * api字段类型与mysql映射
 */
public enum ApiMappingMysqlTypeEnum {

    STRING("string", "VARCHAR", "100", null),
    NUMBER("number", "DECIMAL", "20", "3"),
    NUMERIC("numeric", "DECIMAL", "20", "3"),
    BIT("boolean", "BIT", "1", null),
    DATE("date", "DATE", null, null),
    DATETIME("datetime", "DATETIME", null, null),
    TIME("time", "TIME", null, null);

    private final String code;
    private final String mapping;
    private final String size;
    private final String scale;

    ApiMappingMysqlTypeEnum(String code, String mapping, String size, String scale) {
        this.code = code;
        this.mapping = mapping;
        this.scale = scale;
        this.size = size;
    }

    public String getCode() {
        return code;
    }

    public String getMapping() {
        return mapping;
    }

    public String getSize() {
        return size;
    }

    public String getsScale() {
        return scale;
    }

    public static String getMappingByCode(String code) {
        for (ApiMappingMysqlTypeEnum enums : ApiMappingMysqlTypeEnum.values()) {
            if (enums.getCode().equals(code)) {
                return enums.getMapping();
            }
        }
        return ApiMappingMysqlTypeEnum.STRING.mapping;
    }

    public static String getSizeByCode(String code) {
        for (ApiMappingMysqlTypeEnum enums : ApiMappingMysqlTypeEnum.values()) {
            if (enums.getCode().equals(code)) {
                return enums.getSize();
            }
        }
        return null;
    }

    public static String getScaleByCode(String code) {
        for (ApiMappingMysqlTypeEnum enums : ApiMappingMysqlTypeEnum.values()) {
            if (enums.getCode().equals(code)) {
                return enums.getsScale();
            }
        }
        return null;
    }
}
