package com.digiwin.athena.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * Pagination
 *
 * @author wangjy
 * @date 2021/9/12
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class Pagination<T> {
    @Schema(description = "当前页数")
    private Integer curPageNum;
    @Schema(description = "总页数")
    private Integer totalPageNum;
    @Schema(description = "每页条数")
    private Integer limit;
    @Schema(description = "总条数")
    private Long total;

    private List<T> data;

    public static <T> Pagination<T> buildPagination(PageReqCondition pageReqCondition, List<T> records, Long count) {
        Pagination<T> res = new Pagination<>();
        res.setData(records);
        res.setTotal(count);
        res.setCurPageNum(pageReqCondition.getPageNum());
        res.setTotalPageNum(count.intValue() / pageReqCondition.getPageSize() + 1);
        res.setLimit(pageReqCondition.getPageSize());

        return res;
    }

    public <E> Pagination<E> convert(Function<T, E> func) {
        return Pagination.<E>builder()
                .curPageNum(curPageNum)
                .totalPageNum(totalPageNum)
                .limit(limit)
                .total(total)
                .data(data.stream().map(func).collect(Collectors.toList()))
                .build();
    }
}
