/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.utils;

import com.digiwin.athena.utils.CurThreadInfoUtils;
import java.util.function.Supplier;

public class SwitchAdpVersionUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T switchAdpVersion(String adpVersion, Supplier<T> supplier) {
        String originalAdpVersion = CurThreadInfoUtils.getAdpVersion();
        try {
            CurThreadInfoUtils.setAdpVersion(adpVersion);
            T t = supplier.get();
            return t;
        }
        finally {
            CurThreadInfoUtils.setAdpVersion(originalAdpVersion);
        }
    }

    public static void switchAdpVersion(String adpVersion, Runnable runnable) {
        String originalAdpVersion = CurThreadInfoUtils.getAdpVersion();
        try {
            CurThreadInfoUtils.setAdpVersion(adpVersion);
            runnable.run();
        }
        finally {
            CurThreadInfoUtils.setAdpVersion(originalAdpVersion);
        }
    }

    public static <T> T withTemporaryVersionReset(Supplier<T> supplier) {
        String originalAdpVersion = CurThreadInfoUtils.getAdpVersion();
        try {
            CurThreadInfoUtils.removeAdpVersion();
            T t = supplier.get();
            return t;
        }
        finally {
            CurThreadInfoUtils.setAdpVersion(originalAdpVersion);
        }
    }

    public static void withTemporaryVersionReset(Runnable runnable) {
        String originalAdpVersion = CurThreadInfoUtils.getAdpVersion();
        try {
            CurThreadInfoUtils.removeAdpVersion();
            runnable.run();
        }
        finally {
            CurThreadInfoUtils.setAdpVersion(originalAdpVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T switchAdpStatus(String adpState, Supplier<T> supplier) {
        String originalAdpState = CurThreadInfoUtils.getAdpStatus();
        try {
            CurThreadInfoUtils.setAdpStatus(adpState);
            T t = supplier.get();
            return t;
        }
        finally {
            CurThreadInfoUtils.setAdpStatus(originalAdpState);
        }
    }

    public static void switchAdpStatus(String adpState, Runnable runnable) {
        String originalAdpState = CurThreadInfoUtils.getAdpStatus();
        try {
            CurThreadInfoUtils.setAdpStatus(adpState);
            runnable.run();
        }
        finally {
            CurThreadInfoUtils.setAdpStatus(originalAdpState);
        }
    }
}

