package com.digiwin.athena.base;

public class BaseConstant {

    public static final String SEMICOLON_SEPARATOR = ";";

    public static final String COMMA_SEPARATOR = ",";

    public static final String UNDERLINE = "_";

    public static final String LEFT_BRACKET = "[";

    public static final String RIGHT_BRACKET = "]";

    public static final String NULL_STR = "NULL";

    public static final String COLON=":";

    public static final String HYPHEN="-";
    public static final String DOT=".";
    public static final String LEFT_BRACE="{";
    public static final String RIGHT_BRACE="}";
    public static final String STAR="*";
    public static final String PIPE="|";
    public static final String EQUALS_SIGN = "=";

    public static class OrderType {
        public static final Integer DESC = 0;

        public static final Integer ASC = 1;
    }

    public static class CompareType {
        /**
         * 包含
         */
        public static final int CONTAINS = 0;

        /**
         * 在...之内
         */
        public static final int IN = 1;

        /**
         * 等于
         */
        public static final int EQUAL = 2;

        /**
         * 大于
         */
        public static final int GT = 4;

        /**
         * 小于
         */
        public static final int LT = 5;

        /**
         * 不等于
         */
        public static final int NOTEQUAL = 6;

        /**
         * 以...开始
         */
        public static final int START_WITH = 7;

        /**
         * 以...结束
         */
        public static final int END_WITH = 8;

        /**
         * 不包含
         */
        public static final int NOT_CONTAINS = 9;

        /**
         * 不在...之内
         */
        public static final int NOT_IN = 10;

        /**
         * true false
         */
        public static final int TF = 11;

        /**
         * 大于等于
         */
        public static final int GE = 12;

        /**
         * 小于等于
         */
        public static final int LE = 13;

        /**
         * 为空
         */
        public static final int IS_NULL = 14;

        /**
         * 不为空
         */
        public static final int NOT_NULL = 15;

        /**
         * 存在等于
         */
        public static final int EXISTS_EQUAL = 16;

        /**
         * 存在包含
         */
        public static final int EXISTS_CONTAINS = 17;

        /**
         * 存在大于
         */
        public static final int EXISTS_GT = 18;

        /**
         * 存在小于
         */
        public static final int EXISTS_LT = 19;

        /**
         * 存在在大于等于
         */
        public static final int EXISTS_GE = 20;

        /**
         * 存在小于等于
         */
        public static final int EXISTS_LE = 21;

        /**
         * 存在不在...之内
         */
        public static final int EXISTS_NOT_IN = 22;

        /**
         * 存在为空
         */
        public static final int EXISTS_IS_NULL = 23;

        /**
         * 存在不为空
         */
        public static final int EXISTS_IS_NOT_NULL = 24;
    }

    /**
     * 数据类型
     */
    public static class DataType {
        /**
         * 文本
         */
        public static final int TEXT = 0;

        /**
         * 数字(整型)
         */
        public static final int NUMBER = 1;

        /**
         * 数字(浮点型)
         */
        public static final int DECIMAL = 2;

        /**
         * 日期
         */
        public static final int DATE = 3;
    }

    /**
     * 与或
     */
    public static class AndOr {
        public static final int AND = 0;

        public static final int OR = 1;
    }

    /**
     * 专案部署有关常量
     */
    public static class DeployApp {

        // 专案部署记录类型-新增
        public static final String DEPLOYAPP_OPERATETYE_NEW = "new";

        // 专案部署云区类型-共有
        public static final String DEPLOYAPP_CLOUDENV_COMMON = "common";

        // 专案部署记录类型-追加
        public static final String DEPLOYAPP_OPERATETYE_APPEND = "append";
    }
}
