package com.digiwin.athena.base;

import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

import jakarta.validation.ValidationException;

/**
 * BaseController
 *
 * @author wangjy
 * @date 2021/11/18
 */
public class BaseController {
    protected void validData(BindingResult bindingResult) {
        String msgFormat = "parameter {%s}%s";
        if (bindingResult.hasErrors()) {
            StringBuilder sb = new StringBuilder();
            for (ObjectError error : bindingResult.getAllErrors()) {
                int index = error.getCodes()[0].indexOf(".");
                String field = error.getCodes()[0].substring(index + 1);
                String message = String.format(msgFormat, field, error.getDefaultMessage());
                sb.append(message);
            }
            throw new ValidationException(sb.toString());
        }
    }
}
