package com.digiwin.athena.constant.modelDriven;

import lombok.Getter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * 系统字段枚举
 */
public enum SystemFieldEnum {

    CREATE_BY("create_by", "创建者"),

    CREATE_DATE("create_date", "创建时间"),

    MODIFIED_BY("modified_by", "修改者"),

    MODIFIED_DATE("modified_date", "修改时间"),

    CREATOR_NAME("creator_name", "创建者名称"),

    MODIFIER_NAME("modifier_name", "修改者名称");

    @Getter
    private final String code;

    @Getter
    private final String name;

    SystemFieldEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static boolean isContains(String code) {
        Set<String> validOperations = new HashSet<>(Arrays.asList(
                SystemFieldEnum.CREATE_BY.getCode(),
                SystemFieldEnum.CREATE_DATE.getCode(),
                SystemFieldEnum.MODIFIED_BY.getCode(),
                SystemFieldEnum.MODIFIED_DATE.getCode(),
                SystemFieldEnum.CREATOR_NAME.getCode(),
                SystemFieldEnum.MODIFIER_NAME.getCode()
        ));
        return validOperations.contains(code);
    }
}
