package com.digiwin.athena.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.data.domain.Pageable;

public class PageReqCondition<T> {
    @Schema(description = "每页条数")
    private Integer pageSize=10;
    @Schema(description = "页码")
    private Integer pageNum=1;
    @Schema(description = "查询条件")
    private T condition;
    @Schema(description = "高级查询条件")
    private AdvancedQueryParam advancedQueryParams;

    public AdvancedQueryParam getAdvancedQueryParams() {
        return advancedQueryParams;
    }

    public void setAdvancedQueryParams(AdvancedQueryParam advancedQueryParams) {
        this.advancedQueryParams = advancedQueryParams;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public T getCondition() {
        return condition;
    }

    public void setCondition(T condition) {
        this.condition = condition;
    }


    public Pageable toPageable() {
        return Pageable.ofSize(pageSize).withPage(pageNum - 1);
    }
}