package com.digiwin.athena.enums;


import lombok.Getter;

/**
 * 删除流程进度
 * @date 2024/9/23 16:42
 */
@Getter
public enum DeleteApplicationProcessEnum {

    UC_VALID("uc_valid", 5,"个案校验"),

    VALID_PUBLISH("valid_publish", 10,"发版校验"),

    DELETE_ABI_REPORT("delete_abi_report",20, "删除ABI报表"),

    DELETE_TBB_REPORT("delete_tbb_report",21, "删除TBB报表"),

    DELETE_DEPLOY_SPECIAL("delete_deploy_special",30,"删除部署专案"),

    AUTO_BACKUP("auto_backup", 40,"自动备份"),

    THIRDPARTY_INTERFACE("thirdparty_interface", 45,"解决方案第三方删除调用"),

    DELETE_CAC_IAM("delete_om",50,"删除CAC和Iam数据"),

    DELETE_KM("delete_km",60,"删除km数据"),

    DELETE_DB_TB("delete_db_tb",70,"删除数据库数据"),

    DELETE_API("delete_api",80,"删除api管理台数据"),

    MESSAGE_CENTER("message_center",85,"删除消息中心相关数据"),

    DELETE_DESIGN("delete_design",90,"删除设计态相关数据数据"),

    DELETE_ASSET("delete_asset",100,"删除资产");

    private final String type;

    private final Integer order;

    private final String content;

    DeleteApplicationProcessEnum(String type, Integer order, String content){
        this.type = type;
        this.order = order;
        this.content = content;
    }
}
