package com.digiwin.athena.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipUtil {

    // 压缩
    public static byte[] compress(byte[] data) throws IOException {
        if (data == null || data.length == 0) return data;

        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOut = new GZIPOutputStream(byteArrayOutputStream)) {
            gzipOut.write(data);
        }
        return byteArrayOutputStream.toByteArray();
    }

    // 解压
    public static byte[] decompress(byte[] compressedData) throws IOException {
        if (compressedData == null || compressedData.length == 0) return compressedData;

        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedData);
        ByteArrayOutputStream out = new ByteArrayOutputStream();

        try (GZIPInputStream gzipIn = new GZIPInputStream(byteArrayInputStream)) {
            byte[] buffer = new byte[1024];
            int len;
            while ((len = gzipIn.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }

        return out.toByteArray();
    }


    public static void main(String[] args) throws IOException {

        byte[] bs={31,-117,8,0,0,0,0,0,0,0,-35,88,109,79,19,89,20,-2,43,77,63,-125,105,-95,-81,124,90,44,100,-41,100,53,-84,-44,108,54,-122,52,-73,51,-73,48,-38,-50,116,103,-90,-72,104,72,80,121,41,-96,-117,70,80,20,87,44,-118,84,-93,69,87,20,45,111,127,-122,121,-23,-65,-40,123,103,-90,-45,121,-71,51,45,-80,95,118,63,17,50,61,-49,121,-98,115,-49,61,-9,-100,115,43,8,-118,-59,60,67,1,-111,-31,-40,96,95,112,40,-107,10,118,5,41,-82,80,-32,-40,-2,98,49,-40,-105,3,121,1,118,5,33,59,-114,-66,-2,84,2,55,32,-109,-122,-126,-40,-99,30,28,78,-93,95,50,-96,-48,79,-45,67,28,-126,-104,24,2,60,40,4,-5,-82,-34,34,98,2,65,96,70,-39,2,100,-59,-97,25,65,-44,126,70,113,52,68,-33,-77,64,-128,3,64,4,-125,-84,-56,79,12,-15,-36,53,72,-119,23,97,-127,-29,65,-106,-55,51,0,-39,-78,-96,-128,127,-40,-88,124,87,-42,106,-46,-21,-83,-29,-6,-94,90,-5,24,-100,-20,34,99,92,102,-124,-21,-87,-110,32,114,-123,-117,-128,97,69,-56,2,-106,-126,45,24,-87,60,-85,124,-38,83,-25,-34,73,-75,103,-57,-33,-25,-107,-67,29,121,-31,-75,21,12,-1,-71,92,-54,67,-94,-75,-78,-1,88,121,121,91,-35,-102,-106,-54,79,-35,-90,38,-121,76,-111,-94,12,45,-65,-108,80,-64,80,40,52,-35,14,49,-115,39,-75,-58,-58,-86,-4,109,70,-70,-65,-30,-127,-93,-125,100,24,54,-57,101,-14,4,-120,-29,-93,-118,124,123,91,94,-33,84,-98,47,-6,67,8,-48,-19,127,109,86,58,88,-111,102,54,-55,-106,-65,27,-44,-45,19,69,72,-90,-114,34,41,-67,88,-12,11,-60,13,-114,-65,-98,-95,33,62,-3,76,1,125,-52,103,112,108,50,69,-56,11,28,-53,-94,127,69,30,-80,66,14,-14,45,7,-57,-11,-70,-12,112,85,61,120,47,-17,28,-38,64,7,51,-31,36,8,-123,122,99,-31,120,36,-44,19,14,-123,66,78,86,-14,-62,-90,-12,112,65,89,94,-105,-53,15,-44,-38,33,58,98,18,64,-116,-118,39,104,-54,7,64,90,122,-40,-104,-70,-115,-110,12,69,-57,1,-48,19,-50,70,122,99,-70,113,79,-120,-78,-28,-25,-15,-34,-98,-76,80,-63,0,-69,-101,14,-93,4,-56,38,117,-109,112,36,-106,-80,-102,-68,83,43,85,-13,8,-43,-19,13,-89,33,5,35,-15,104,-60,48,-115,-60,45,-119,-88,-59,-68,113,-16,64,-38,124,34,87,43,-14,-30,-70,90,-85,40,-75,39,-22,-67,-69,-46,-38,-114,21,-58,56,-1,-63,63,-118,28,47,-2,-56,113,-76,112,-127,61,15,68,106,12,10,-82,-53,85,-98,-107,-25,-65,75,115,117,117,103,75,-3,50,45,63,38,-28,-72,1,-105,-122,-123,98,30,-120,-82,-68,-64,92,-2,58,-14,54,67,-87,100,38,-121,-45,86,-49,38,119,70,-118,0,-35,-24,60,46,33,57,-93,-82,16,32,-12,-16,-21,-73,-101,12,49,-64,-28,-112,125,41,47,78,12,-64,81,30,-62,-13,64,96,-88,126,-98,26,99,-58,-83,-95,-48,-127,26,-49,14,-91,-6,27,-27,-13,-98,-68,-14,81,90,-81,43,-107,41,-71,-14,-54,-119,-40,12,-126,86,-5,-96,104,75,98,61,27,-76,104,72,75,119,16,74,112,114,-60,-89,-110,-78,52,51,-50,-48,37,-112,55,-117,46,-70,45,-88,10,93,-96,-11,-6,-58,80,86,-51,90,93,18,-81,8,-24,22,105,-75,-108,43,-22,-43,54,-36,-4,-92,-103,13,-122,67,-79,80,106,40,-115,29,-103,70,-105,116,126,-24,91,38,118,46,-44,-40,-104,-106,-65,44,-86,-37,43,-54,22,-70,51,-69,-26,-81,-122,25,4,16,9,39,-109,-79,120,52,20,-118,-122,-62,-47,88,2,-13,23,-71,-21,16,87,117,42,22,-119,102,123,-78,-71,110,24,-113,-9,116,71,98,52,-20,6,9,42,-47,13,33,-56,81,-67,89,100,3,-110,-102,96,-4,68,-104,-75,-65,-65,36,-114,113,60,115,83,15,-104,-48,-63,107,17,-20,107,115,29,44,114,-121,127,27,78,15,94,-20,-8,-118,116,5,75,69,26,29,94,74,127,-18,40,-99,-127,22,-4,73,-12,8,-106,120,30,-22,33,-58,28,-14,28,5,-14,24,-12,-26,88,38,117,9,-39,10,56,64,-47,24,-86,70,-15,72,50,22,-21,13,39,-30,61,54,54,64,28,67,-1,12,-64,113,103,-28,-5,-75,15,82,125,89,89,-82,74,-5,83,-88,-42,-40,-93,30,13,39,122,19,72,98,52,-103,-64,-8,39,-116,57,82,-123,40,107,12,114,-91,107,-39,31,104,102,-108,-71,-63,-80,-25,-48,-93,110,124,51,104,72,119,102,-92,-38,87,105,-26,11,74,-22,-1,120,90,-30,60,99,33,-92,-51,-12,26,-98,-48,-3,-93,-28,75,113,72,-126,-50,-30,-22,-120,103,47,-127,-108,-46,29,-11,34,121,-64,-114,-30,124,-48,113,110,-31,116,72,-1,-118,-93,-7,-79,44,87,-54,6,96,117,53,-120,67,-102,-71,50,-116,51,90,-121,9,88,113,38,39,-3,-30,-120,-117,-116,39,115,114,-5,66,-30,-17,-43,7,121,74,40,-49,54,42,47,116,100,-27,-16,-83,-14,-11,-125,-6,97,-41,34,-60,-53,-77,126,35,60,27,-85,-74,82,-67,59,43,67,21,-71,33,-13,-110,-95,-20,86,-107,-115,125,-11,-51,-110,52,63,-25,-46,-112,66,80,1,-116,21,-80,-126,117,-52,-111,-48,-75,25,28,59,-24,-4,-38,-92,-50,-54,82,-93,114,15,-125,62,-82,89,8,19,61,54,35,78,106,34,79,-97,89,-124,126,-46,45,-114,-48,-114,-6,-21,82,63,-49,-87,-43,5,19,-49,-82,-53,-31,-52,-82,-53,-34,-39,-98,85,87,-85,-43,-11,20,-91,55,-56,-2,114,16,76,-29,-34,-76,14,-29,56,35,-117,3,-57,1,-75,-70,-20,-45,36,-102,-83,-57,118,-111,119,-12,-24,-99,36,25,-70,-27,24,-48,121,55,124,124,-110,18,-50,-34,-6,-97,-2,120,108,-35,-66,75,-34,73,-58,7,47,-19,-40,-61,-93,-118,122,48,-81,123,104,-22,117,56,110,106,-76,79,31,103,77,59,-62,64,-46,-44,72,-100,102,-38,-100,-33,-53,79,45,-76,-22,7,29,-51,126,126,68,-121,-10,-13,35,13,73,-1,-114,78,-37,-36,-28,-48,105,31,-70,58,-46,-7,116,31,-93,85,87,-47,-115,-13,-48,-23,112,72,-46,105,-97,-27,-50,-112,-89,-42,-15,-82,-91,-115,48,15,122,-26,33,66,88,124,-118,-75,-19,90,-53,71,26,13,18,1,30,-30,-23,-52,-102,-122,-74,105,-14,44,-76,93,35,102,-117,-68,107,46,-11,60,-106,-23,41,-124,98,-42,114,-11,-19,-122,-11,34,-111,92,-76,116,-72,71,-36,-45,-85,105,-37,-46,-101,-54,-36,-109,-126,103,-61,-96,21,-62,-58,-63,-126,-127,-7,-24,-67,90,45,35,76,101,123,90,122,126,-33,-94,-77,-83,-13,-90,-26,118,-77,-7,-55,94,1,-49,-95,-36,80,-21,63,-33,-73,-71,104,38,-10,-33,-8,116,49,-74,-13,89,-16,-121,-73,-33,56,-17,-3,-63,-55,36,-37,-106,8,118,-103,-106,-67,-125,-65,52,3,-61,41,-89,-39,-114,-117,6,78,0,-115,-128,32,0,117,30,39,99,105,91,87,56,88,58,-42,28,109,-102,10,-19,65,118,-11,21,38,85,4,102,-91,-23,-116,-70,125,109,-46,-87,6,-62,-66,-60,-48,-32,-65,110,105,83,-35,-76,33,-62,37,69,-85,113,118,-52,83,5,-34,111,55,99,97,-33,110,-45,-29,-81,-95,-79,-10,10,-63,31,31,-35,-111,87,-66,97,-8,-41,127,-54,-17,-106,45,98,-76,-13,-32,114,1,-36,-101,-100,65,-123,109,55,100,33,79,90,42,-7,19,110,34,-35,69,-124,-99,65,55,-13,-68,-40,-124,35,-89,18,105,95,-27,-81,103,-60,57,-17,-113,-24,-5,-123,-1,-3,-70,100,-14,31,-52,-9,25,-62,55,25,0,0};
        System.out.println(decompress(bs));


    }
}
