package com.digiwin.athena.utils;

import java.util.function.Supplier;

public class SwitchDatabaseUtils {

    public static <T> T switchStandardDatabase(Supplier<T> supplier){
        Boolean individualCase = CurThreadInfoUtils.getIndividualCase();

        try {
            CurThreadInfoUtils.setIndividualCase(false);
            return supplier.get();
        } finally {
            CurThreadInfoUtils.setIndividualCase(individualCase);
        }
    }

    public static <T> T switchIndividualDatabase(Supplier<T> supplier){
        Boolean individualCase = CurThreadInfoUtils.getIndividualCase();

        try {
            CurThreadInfoUtils.setIndividualCase(true);
            return supplier.get();
        } finally {
            CurThreadInfoUtils.setIndividualCase(individualCase);
        }
    }

    public static void switchStandardDatabase(Runnable runnable){
        Boolean individualCase = CurThreadInfoUtils.getIndividualCase();

        try {
            CurThreadInfoUtils.setIndividualCase(false);
            runnable.run();
        } finally {
            CurThreadInfoUtils.setIndividualCase(individualCase);
        }
    }

    public static void switchIndividualDatabase(Runnable runnable){
        Boolean individualCase = CurThreadInfoUtils.getIndividualCase();

        try {
            CurThreadInfoUtils.setIndividualCase(true);
            runnable.run();
        } finally {
            CurThreadInfoUtils.setIndividualCase(individualCase);
        }
    }

    public static <T> T switchBranchDatabase(String branch,Supplier<T> supplier){
        String originalBranchKey = CurThreadInfoUtils.getBranchKey();
        try {
            CurThreadInfoUtils.setBranchKey(branch);
            return supplier.get();
        } finally {
            CurThreadInfoUtils.setBranchKey(originalBranchKey);
        }
    }

    public static void switchBranchDatabase(String branch,Runnable runnable){
        String originalBranchKey = CurThreadInfoUtils.getBranchKey();
        try {
            CurThreadInfoUtils.setBranchKey(branch);
            runnable.run();
        } finally {
            CurThreadInfoUtils.setBranchKey(originalBranchKey);
        }
    }
}
