package com.digiwin.athena.constant.enumconstant;

import lombok.Getter;

/**
 * 属性相关配置没蕨类
 * 任务引擎映射类-专用
 */
public enum ExecutorTypeEnum {

    /**
     * 指定人员
     */
    PERSONNEL("personnel", "user"),

    /**
     * 指定职能
     */
    DUTY("duty", "duty"),

    /**
     * deptUser
     */
    SUPERIOR("superior", "userSuperior"),

    /**
     * 部门主管
     */
    DIRECTOR("director", "deptDirector"),

    /**
     * 默认
     */
    DEFAULT("default", "user");

    @Getter
    private final String code;

    @Getter
    private final String mappingCode;

    ExecutorTypeEnum(String code, String mappingCode) {
        this.code = code;
        this.mappingCode = mappingCode;
    }

    public static String getMappingCode(String code) {
        for (ExecutorTypeEnum executorTypeEnum : ExecutorTypeEnum.values()) {
            if (executorTypeEnum.getCode().equals(code)) {
                return executorTypeEnum.getMappingCode();
            }
        }
        return null;
    }
}
