package com.digiwin.athena.runtime.neo4j.domain;

import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Properties;
import org.neo4j.ogm.annotation.Relationship;

import java.util.List;
import java.util.Map;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @CreateDate 2022/6/13 <br>
 */
@NodeEntity
public class DomainEntity {
    @Id
    @GeneratedValue
    private Long neo4jId;
    private String id;
    private String version;
    private Integer d;
    private Integer trait;
    @Relationship(
            type = "IMPL"
    )
    private List<DomainEntity> impl;
    @Properties
    private Map<String, Object> properties;
    @Properties
    private Map<String, Map<String, String>> lang;
    @Properties
    private Map<String, Map<String, String>> language;

    public DomainEntity() {
    }

    public Long getNeo4jId() {
        return this.neo4jId;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getD() {
        return this.d;
    }

    public Integer getTrait() {
        return this.trait;
    }

    public List<DomainEntity> getImpl() {
        return this.impl;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, Map<String, String>> getLang() {
        return this.lang;
    }

    public Map<String, Map<String, String>> getLanguage() {
        return this.language;
    }

    public void setNeo4jId(Long neo4jId) {
        this.neo4jId = neo4jId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setD(Integer d) {
        this.d = d;
    }

    public void setTrait(Integer trait) {
        this.trait = trait;
    }

    public void setImpl(List<DomainEntity> impl) {
        this.impl = impl;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setLang(Map<String, Map<String, String>> lang) {
        this.lang = lang;
    }

    public void setLanguage(Map<String, Map<String, String>> language) {
        this.language = language;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof DomainEntity)) {
            return false;
        } else {
            DomainEntity other = (DomainEntity)o;
            if (!other.canEqual(this)) {
                return false;
            } else {
                label119: {
                    Object this$neo4jId = this.getNeo4jId();
                    Object other$neo4jId = other.getNeo4jId();
                    if (this$neo4jId == null) {
                        if (other$neo4jId == null) {
                            break label119;
                        }
                    } else if (this$neo4jId.equals(other$neo4jId)) {
                        break label119;
                    }

                    return false;
                }

                Object this$id = this.getId();
                Object other$id = other.getId();
                if (this$id == null) {
                    if (other$id != null) {
                        return false;
                    }
                } else if (!this$id.equals(other$id)) {
                    return false;
                }

                label105: {
                    Object this$version = this.getVersion();
                    Object other$version = other.getVersion();
                    if (this$version == null) {
                        if (other$version == null) {
                            break label105;
                        }
                    } else if (this$version.equals(other$version)) {
                        break label105;
                    }

                    return false;
                }

                Object this$d = this.getD();
                Object other$d = other.getD();
                if (this$d == null) {
                    if (other$d != null) {
                        return false;
                    }
                } else if (!this$d.equals(other$d)) {
                    return false;
                }

                label91: {
                    Object this$trait = this.getTrait();
                    Object other$trait = other.getTrait();
                    if (this$trait == null) {
                        if (other$trait == null) {
                            break label91;
                        }
                    } else if (this$trait.equals(other$trait)) {
                        break label91;
                    }

                    return false;
                }

                Object this$impl = this.getImpl();
                Object other$impl = other.getImpl();
                if (this$impl == null) {
                    if (other$impl != null) {
                        return false;
                    }
                } else if (!this$impl.equals(other$impl)) {
                    return false;
                }

                label77: {
                    Object this$properties = this.getProperties();
                    Object other$properties = other.getProperties();
                    if (this$properties == null) {
                        if (other$properties == null) {
                            break label77;
                        }
                    } else if (this$properties.equals(other$properties)) {
                        break label77;
                    }

                    return false;
                }

                label70: {
                    Object this$lang = this.getLang();
                    Object other$lang = other.getLang();
                    if (this$lang == null) {
                        if (other$lang == null) {
                            break label70;
                        }
                    } else if (this$lang.equals(other$lang)) {
                        break label70;
                    }

                    return false;
                }

                Object this$language = this.getLanguage();
                Object other$language = other.getLanguage();
                if (this$language == null) {
                    if (other$language != null) {
                        return false;
                    }
                } else if (!this$language.equals(other$language)) {
                    return false;
                }

                return true;
            }
        }
    }

    protected boolean canEqual(Object other) {
        return other instanceof DomainEntity;
    }

    public int hashCode() {
        boolean PRIME = true;
        int result = 1;
        Object $neo4jId = this.getNeo4jId();
        result = result * 59 + ($neo4jId == null ? 43 : $neo4jId.hashCode());
        Object $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Object $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Object $d = this.getD();
        result = result * 59 + ($d == null ? 43 : $d.hashCode());
        Object $trait = this.getTrait();
        result = result * 59 + ($trait == null ? 43 : $trait.hashCode());
        Object $impl = this.getImpl();
        result = result * 59 + ($impl == null ? 43 : $impl.hashCode());
        Object $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        Object $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        Object $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        return result;
    }

    public String toString() {
        return "DomainEntity(neo4jId=" + this.getNeo4jId() + ", id=" + this.getId() + ", version=" + this.getVersion() + ", d=" + this.getD() + ", trait=" + this.getTrait() + ", impl=" + this.getImpl() + ", properties=" + this.getProperties() + ", lang=" + this.getLang() + ", language=" + this.getLanguage() + ")";
    }
}