package com.digiwin.athena.utils;

import com.digiwin.athena.base.BusinessException;
import org.springframework.util.StringUtils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @CreateDate 2023/1/5 <br>
 */
public class MD5 {

    public static String getFileMD5(String value) {
        if(StringUtils.isEmpty(value)){
            return "";
        }
        try(InputStream in = convertStringToInputStream(value)) {

            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte buffer[] = new byte[1024];
            int len;
            while ((len = in.read(buffer)) != -1) {
                digest.update(buffer, 0, len);
            }
            BigInteger bigInt = new BigInteger(1, digest.digest());
            return bigInt.toString(16);
        } catch (Exception e){
            throw new BusinessException("Failed to obtain MD5 value of data, data:" + value);
        }
    }

    private static InputStream convertStringToInputStream(String value) {
        InputStream result = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
        return result;

    }

    public static String getMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input.getBytes());
            byte[] digest = md.digest();
            return bytesToHex(digest);
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 Algorithm not found", e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xff & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
    
}