package com.digiwin.athena.base;

/**
 * ResultCode
 *
 * @author wangjy
 * @date 2021/8/9
 */
public enum ResultCode {
    /**
     * 参数错误
     */
    PARAM_NOT_COMPLETE(1001, "Missing parameter"),
    PARAM_TYPE_BIND_ERROR(1002, "Parameter type error"),
    PARAM_ERROR(1003, "Parameter error"),
    NO_AUDIT(1004, "该权限已被审批"),
    NO_IAM_AUTH(21007, "IAM鉴权未通过"),
    /**
     * 服务错误
     */
    ID_NOT_EXIST(2001, "ID does not exist"),
    JSON_FILE_ERROR(2002, "Error in json file"),
    DATA_NOT_EXIST(2003, "Data does not exist"),
    PRIMARY_KEY_EXIST(2004, "Duplicate primary key"),
    QUERY_DATA_NOT_UNIQUE(2005, "Query data based on primary key is not unique"),
    COMMON_ERROR_CODE(1000, "common error msg"),

    /**
     * token失效或者鉴权失败
     */
    TOKEN_EXPIRED(1010001, "鉴权失败，请重新登陆");

    private Integer code;
    private String message;

    ResultCode(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

}
