package com.digiwin.athena.constant;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;

import java.util.Map;
import java.util.Set;

/**
 * TagConstant
 *
 * @author wangjy
 * @date 2021/9/6
 */
public class TagConstant {
    /**
     * request params
     */
    public static final String REQUEST_PARAM_BINDINGS = "bindings";

    /**
     * Json Data Path
     */
    public final static String RELEASE_MONGO_DATA_PATH = "./src/main/resources/release/mongo";
    public final static String RELEASE_NEO4J_DATA_PATH = "./src/main/resources/release/neo4j";
    public final static String RELEASE_MONGO_DATA_PATH_APP_FOLDER_FORMAT = RELEASE_MONGO_DATA_PATH + "/%s/%s/%s";
    public final static String RELEASE_NEO4J_DATA_PATH_APP_FOLDER_FORMAT = RELEASE_NEO4J_DATA_PATH + "/%s/%s";
    public final static String RELEASE_MONGO_DATA_PATH_FORMAT = RELEASE_MONGO_DATA_PATH_APP_FOLDER_FORMAT + "/%s.json";
    public final static String RELEASE_NEO4J_DATA_PATH_FORMAT = RELEASE_NEO4J_DATA_PATH_APP_FOLDER_FORMAT + "/%s.json";
    public final static String MIDDLE_MONGO_DATA_PATH_APP_FOLDER_FORMAT = "./src/main/resources/middle/mongo/%s/%s/%s";
    public final static String MIDDLE_NEO4J_DATA_PATH_APP_FOLDER_FORMAT = "./src/main/resources/middle/neo4j/%s/%s";
    public final static String MIDDLE_MONGO_DATA_PATH_FORMAT = MIDDLE_MONGO_DATA_PATH_APP_FOLDER_FORMAT + "/%s.json";
    public final static String MIDDLE_NEO4J_DATA_PATH_FORMAT = MIDDLE_NEO4J_DATA_PATH_APP_FOLDER_FORMAT + "/%s.json";
    public final static String COMMON_PATH = "COMMON";
    public final static String PRESET_DATA_KEY_CATEGORY = "category";
    public final static String PRESET_DATA_KEY_PUBLIC_CATEGORY = "public_category";
    public final static String PRESET_DATA_KEY_PRIVATE_CATEGORY = "private_category";
    public final static String PRESET_DATA_KEY_ATTR = "builtInAttr";

    /**
     * business
     */
    public final static String TYPE_GENERAL = "general";

    /**
     * PC端-执行者类型
     */
    public final static String TYPE_PERFORMER = "performer";

    /**
     * 移动端-当责者类型
     */
    public final static String TYPE_CHARGE = "charge";

    /**
     * 移动端-执行者类型
     * tag与taskaction均会用到
     */
    public static final String TYPE_PERFORMER_MOBILE = "performer-mobile";

    /**
     * 移动端-当责者类型
     * tag与taskaction均会用到
     */
    public static final String TYPE_CHARGE_MOBILE = "charge-mobile";
    public final static String TYPE_OPEN_WINDOW = "DIALOG";
    public final static String SINGLE_CODE_SEPARATOR = "_";
    public final static String DOUBLE_CODE_SEPARATOR = "__";
    public final static String RESOURCE_CONTENT_FORMAT = "{'response': '%s.%s.%s'}";
    public final static String ATTR_TYPE_REQUEST = "request";
    public final static String ATTR_TYPE_RESPONSE = "response";
    public final static String LABEL_NAME_TAG = "Tag";
    public final static String LABEL_NAME_RELATED_OBJECT = "RelatedObject";
    public final static String LABEL_NAME_LANGUAGE = "Language";
    public final static String MONGO_DB_NAME_TAG_SYSTEM = "tagSystem";
    public final static String DUCUMENT_NAME_TAGGING_DATA = "taggingData";
    public final static String RELATIONSHIP_USE = "USE";
    public final static String RELATIONSHIP_TRANSLATION = "TRANSLATION";
    public final static int GENERAL_TAG_LENGTH = 2;
    public final static int INDIVIDUATION_TAG_LENGTH = 3;
    public final static String CATEGORY_ROLE_ACTIVITY = "ROLE__ACTIVITY";
    public final static String CATEGORY_ORDER = "ORDER";
    public final static String CATEGORY_DISPLAY = "DISPLAY";
    public final static String CATEGORY_APPLICATION = "APPLICATION";
    public final static String CATEGORY_BUSINESS = "BUSINESS";

    public static final long ROLE_TYPE_CHARGE = 1L;

    public static final long ROLE_TYPE_PERFORMER = 2L;

    public static final long ROLE_TYPE_GENERAL = 3L;

    public static final long ROLE_TYPE_CHARGE_MOBILE = 4L;

    public static final long ROLE_TYPE_PERFORMER_MOBILE = 5L;

    public final static Integer EXIST_IN_TABLE = 1;
    public final static Integer EXIST_IN_TEMPLATE = 2;
    public final static Integer EXIST_IN_TABLE_AND_TEMPLATE = 3;


}
