/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.data.mongodb.core.query.Criteria;

public class QueryGroup {
    @Schema(description="\u67e5\u8be2\u6761\u4ef6\u7ec4\u4e4b\u95f4\u7684\u5173\u7cfb|AND,OR")
    private String relation;
    private List<QueryCondition> conditions = new ArrayList<QueryCondition>();

    public Criteria buildCriteria() {
        Criteria criteria = new Criteria();
        ArrayList<Criteria> andCriList = new ArrayList<Criteria>();
        ArrayList<Criteria> orCriList = new ArrayList<Criteria>();
        for (QueryCondition condition : this.conditions) {
            Criteria sub = condition.buildCriteria();
            if ("AND".equals(condition.getRelation())) {
                andCriList.add(sub);
                continue;
            }
            orCriList.add(sub);
        }
        if (!andCriList.isEmpty()) {
            criteria.andOperator(andCriList);
        }
        if (!orCriList.isEmpty()) {
            ArrayList<Criteria> or = new ArrayList<Criteria>();
            or.addAll(orCriList);
            or.add(criteria);
            criteria = new Criteria().orOperator(or);
        }
        return criteria;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public List<QueryCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<QueryCondition> conditions) {
        this.conditions = conditions;
    }

    public static class QueryCondition {
        @Schema(description="\u67e5\u8be2\u5b57\u6bb5")
        private String field;
        @Schema(description="\u5b57\u6bb5\u6761\u4ef6\u64cd\u4f5c")
        private String operator;
        private Object value;
        @Schema(description="\u67e5\u8be2\u6761\u4ef6\u4e4b\u95f4\u7684\u5173\u7cfb|AND,OR")
        private String relation;

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getRelation() {
            return this.relation;
        }

        public void setRelation(String relation) {
            this.relation = relation;
        }

        public Criteria buildCriteria() {
            Criteria where = Criteria.where((String)this.field);
            if (this.operator.equals(QueryOperator.Equals.getOperator())) {
                where.is(this.value);
            } else if (this.operator.equals(QueryOperator.Contains.getOperator())) {
                Pattern pattern = Pattern.compile(".*" + Pattern.quote(this.getValue().toString()) + ".*", 2);
                where.regex(pattern);
            } else if (this.operator.equals(QueryOperator.NotContains.getOperator())) {
                Pattern pattern = Pattern.compile(".*" + Pattern.quote(this.getValue().toString()) + ".*", 2);
                where.not().regex(pattern);
            } else if (this.operator.equals(QueryOperator.ArrayContains.getOperator())) {
                where.is(this.value);
            } else if (this.operator.equals(QueryOperator.ArrayNotContains.getOperator())) {
                where.ne(this.value);
            } else if (this.operator.equals(QueryOperator.NotEquals.getOperator())) {
                where.ne(this.value);
            } else if (this.operator.equals(QueryOperator.GreaterThan.getOperator())) {
                where.gt(this.value);
            } else if (this.operator.equals(QueryOperator.LessThan.getOperator())) {
                where.lt(this.value);
            } else if (this.operator.equals(QueryOperator.GreaterThanEquals.getOperator())) {
                where.gte(this.value);
            } else if (this.operator.equals(QueryOperator.LessThanEquals.getOperator())) {
                where.lte(this.value);
            }
            return where;
        }
    }

    public static enum QueryOperator {
        Contains("contains"),
        NotContains("not_contains"),
        ArrayContains("array_contains"),
        ArrayNotContains("array_not_contains"),
        Equals("equals"),
        NotEquals("not_equals"),
        GreaterThan("greater_than"),
        LessThan("less_than"),
        GreaterThanEquals("greater_than_equals"),
        LessThanEquals("less_than_equals");

        private String operator;

        private QueryOperator(String operator) {
            this.operator = operator;
        }

        public String getOperator() {
            return this.operator;
        }
    }
}

