package com.digiwin.athena.dto;

import org.springframework.data.mongodb.core.query.Criteria;

import java.util.ArrayList;
import java.util.List;

public class AdvancedQueryParam {

    private List<QueryGroup> queryGroups = new ArrayList<>();

    public List<QueryGroup> getQueryGroups() {
        return queryGroups;
    }

    public void setQueryGroups(List<QueryGroup> queryGroups) {
        this.queryGroups = queryGroups;
    }

    public Criteria buildCriteria(){

        if (queryGroups.isEmpty()){
            return null;
        }

        Criteria criteria = new Criteria();

        List<Criteria> andCriList = new ArrayList<>();
        List<Criteria> orCriList = new ArrayList<>();

        for (QueryGroup queryGroup : this.queryGroups) {
            Criteria sub = queryGroup.buildCriteria();
            if ("AND".equals(queryGroup.getRelation())){
                andCriList.add(sub);
            }else{
                orCriList.add(sub);
            }
        }

        if (!andCriList.isEmpty()){
            criteria.andOperator(andCriList);
        }

        if (!orCriList.isEmpty()){
            List<Criteria> or = new ArrayList<>();
            or.addAll(orCriList);
            or.add(criteria);
            criteria = new Criteria().orOperator(or);
        }

        return criteria;
    }
}
