package com.digiwin.athena.dto;


import io.swagger.v3.oas.annotations.media.Schema;

public class ResultDto<T> {
    @Schema(description = "成功编码|0代表成功")
    private Integer code = 0;
    @Schema(description = "异常信息")
    private String msg;

    private T data;

    private ResultDto(){}

    public static <T> ResultDto<T> createSuccess(T date){
        ResultDto<T> resultDto = new ResultDto<>();
        resultDto.code = 0;
        resultDto.data =date;
        return resultDto;
    }

    public static ResultDto createFail(Integer failCode,String errorMessage) {
        ResultDto resultDto = new ResultDto();
        resultDto.code = failCode;
        resultDto.msg = errorMessage;
        return resultDto;
    }

    public static ResultDto createFail(String errorMessage) {
        ResultDto resultDto = new ResultDto();
        resultDto.code = -1;
        resultDto.msg = errorMessage;
        return resultDto;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }
}
