package com.digiwin.athena.utils;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.MongoId;
import org.springframework.data.mongodb.core.query.Update;

import java.lang.reflect.Field;

@Slf4j
public class UpdateUtils {

    public static <T> Update getUpdate(T t) {
        Update update = new Update();
        Field[] fields = t.getClass().getDeclaredFields();
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                Id idAnnotation = field.getAnnotation(Id.class);
                MongoId mongoIdAnnotation = field.getAnnotation(MongoId.class);
                if (idAnnotation != null || mongoIdAnnotation != null) {
                    continue;
                }

                Object value = field.get(t);
                if (value != null) {
                    update.set(field.getName(), value);
                }
            } catch (IllegalAccessException e) {
                log.error("设置Update失败:" + e.getMessage(), e);
            }
        }
        return update;
    }

}
